/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Build.Reader;

import Zenoph.Notify.Enums.DestinationStatus;
import Zenoph.Notify.Enums.DestinationValidation;
import Zenoph.Notify.Store.MessageDestination;
import Zenoph.Notify.Store.PersonalisedValues;
import Zenoph.Notify.Utils.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageDestinationsReader {
    private boolean _done = false;
    private XMLStreamReader _xmlReader = null;

    public void setData(Object data) throws Exception {
        if (data == null || !(data instanceof String)) {
            throw new Exception("Invalid object reference for reading message destinations.");
        }
        String fragment = (String)data;
        this.validateData(fragment);
        XMLInputFactory xif = XMLInputFactory.newInstance();
        ByteArrayInputStream is = new ByteArrayInputStream(fragment.getBytes("UTF-8"));
        XMLStreamReader xmlReader = xif.createXMLStreamReader(is);
        ((InputStream)is).close();
        this.setData(xmlReader);
    }

    public void setData(XMLStreamReader xmlReader) throws Exception {
        if (xmlReader == null) {
            throw new Exception("Invalid object reference for reading message destinations.");
        }
        this._xmlReader = xmlReader;
    }

    public MessageDestination getNextItem() throws Exception {
        if (this._xmlReader == null) {
            throw new Exception("Invalid reference to data reader for next destination item.");
        }
        block4: while (this._xmlReader.hasNext() && !this._done) {
            int eventType = this._xmlReader.next();
            switch (eventType) {
                case 1: {
                    if (!this._xmlReader.getLocalName().equalsIgnoreCase("item")) break;
                    String itemXml = XMLUtil.readNodeOuterXML(this._xmlReader, "item");
                    if (itemXml == null || itemXml.isEmpty()) continue block4;
                    return this.readDestinationItem(itemXml);
                }
                case 2: {
                    String nodeName = this._xmlReader.getLocalName();
                    if (!nodeName.equalsIgnoreCase("destinations")) break;
                    this._done = true;
                }
            }
        }
        return null;
    }

    private MessageDestination readDestinationItem(String itemXml) throws Exception {
        NodeList nodes;
        Node n;
        XPath xpath = XPathFactory.newInstance().newXPath();
        HashMap<String, Object> destInfo = new HashMap<String, Object>();
        Document xmlDoc = XMLUtil.createXMLDocument(itemXml);
        Node node = (Node)xpath.compile("item/to").evaluate(xmlDoc, XPathConstants.NODE);
        if (node != null) {
            destInfo.put("phoneNumber", node.getTextContent());
        }
        if ((node = (Node)xpath.compile("item/country").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            destInfo.put("country", node.getTextContent());
        }
        if ((node = (Node)xpath.compile("item/id").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            destInfo.put("messageId", node.getTextContent());
        }
        if ((node = (Node)xpath.compile("item/message").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            destInfo.put("message", node.getTextContent());
        }
        if ((node = (Node)xpath.compile("item/status").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            n = (Node)xpath.compile("id").evaluate(node, XPathConstants.NODE);
            int statusId = Integer.parseInt(n.getTextContent());
            if (!DestinationStatus.isDefined(statusId)) {
                throw new Exception(String.format("Unknown status identifier '%d' for destination.", statusId));
            }
            destInfo.put("statusId", statusId);
        }
        if ((node = (Node)xpath.compile("item/validation").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            n = (Node)xpath.compile("id").evaluate(node, XPathConstants.NODE);
            int validationId = Integer.parseInt(n.getTextContent());
            if (!DestinationValidation.isDefined(validationId)) {
                throw new Exception(String.format("Unknown validation identifier '%d' for destination", validationId));
            }
            destInfo.put("destValidation", (Object)DestinationValidation.fromInt(validationId));
        }
        if ((node = (Node)xpath.compile("item/messageCount").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            destInfo.put("messageCount", node.getTextContent());
        }
        if ((node = (Node)xpath.compile("item/submitDateTime").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            destInfo.put("submitDateTime", node.getTextContent());
        }
        if ((node = (Node)xpath.compile("item/reportDateTime").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
            destInfo.put("reportDateTime", node.getTextContent());
        }
        if ((nodes = (NodeList)xpath.compile("item/values/value").evaluate(xmlDoc, XPathConstants.NODESET)) != null && nodes.getLength() > 0) {
            String[] values = new String[nodes.getLength()];
            for (int i = 0; i < nodes.getLength(); ++i) {
                values[i] = nodes.item(i).getTextContent();
            }
            destInfo.put("psndValues", new PersonalisedValues(values));
        }
        if (destInfo.size() > 0) {
            return MessageDestination.create(destInfo);
        }
        return null;
    }

    private void validateData(String data) throws Exception {
        String fragmentPattern = "<destinations>(<item>.+</item>)+</destinations>";
    }
}

