/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Build.Reader;

import Zenoph.Notify.Collections.MessageComposerList;
import Zenoph.Notify.Compose.Composer;
import Zenoph.Notify.Compose.MessageComposer;
import Zenoph.Notify.Compose.SMSComposer;
import Zenoph.Notify.Compose.VoiceComposer;
import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Enums.SMSType;
import Zenoph.Notify.Store.AuthProfile;
import Zenoph.Notify.Utils.RequestUtil;
import Zenoph.Notify.Utils.XMLUtil;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MessagePropertiesReader {
    private AuthProfile _authProfile = null;
    private XMLStreamReader _xmlReader = null;
    private boolean _isScheduled = false;
    private boolean _done = false;

    public void setAuthProfile(AuthProfile ap) throws Exception {
        if (ap == null) {
            throw new Exception("Invalid reference to authentication profile object.");
        }
        this._authProfile = ap;
    }

    public void setDataFragment(String dataFragment) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(dataFragment.getBytes(RequestUtil.DEFAULT_TEXT_ENCODING));
        XMLInputFactory xif = XMLInputFactory.newInstance();
        this._xmlReader = xif.createXMLStreamReader(is);
    }

    public void isScheduled(boolean scheduled) {
        this._isScheduled = scheduled;
    }

    private Composer readMessage(String messageFragment) throws Exception {
        MessageComposer mc;
        Document xmlDoc = XMLUtil.createXMLDocument(messageFragment);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.compile("message/batch").evaluate(xmlDoc, XPathConstants.NODE);
        String batchId = node.getTextContent();
        node = (Node)xpath.compile("message/category").evaluate(xmlDoc, XPathConstants.NODE);
        if (node == null) {
            throw new Exception("Message category node was not found.");
        }
        MessageCategory category = MessageCategory.fromInt(Integer.parseInt(node.getTextContent()));
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("batch", batchId);
        hm.put("scheduled", true);
        if (this._authProfile != null) {
            hm.put("authProfile", this._authProfile);
        }
        if (category == MessageCategory.SMS) {
            hm.put("category", (Object)category);
            mc = SMSComposer.create(hm);
            this.setTextMessageProperties((SMSComposer)mc, xmlDoc);
        } else {
            mc = VoiceComposer.create(hm);
            this.setVoiceMessageProperties((VoiceComposer)mc, xmlDoc);
        }
        this.setCommonMessageProperties(mc, xmlDoc);
        return mc;
    }

    private void setTextMessageProperties(SMSComposer tmc, Document xmlDoc) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.compile("message/text").evaluate(xmlDoc, XPathConstants.NODE);
        String messageText = node.getTextContent();
        node = (Node)xpath.compile("message/type").evaluate(xmlDoc, XPathConstants.NODE);
        SMSType type = SMSType.fromInt(Integer.parseInt(node.getTextContent()));
        tmc.setSMSType(type);
        boolean personalise = false;
        node = (Node)xpath.compile("message/personalise").evaluate(xmlDoc, XPathConstants.NODE);
        if (node != null) {
            personalise = node.getTextContent().equalsIgnoreCase("true");
        }
        tmc.setMessage(messageText, personalise);
    }

    private void setVoiceMessageProperties(VoiceComposer vmc, Document xmlDoc) throws Exception {
    }

    private void setCommonMessageProperties(MessageComposer mc, Document xmlDoc) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (mc instanceof MessageComposer) {
            SimpleDateFormat sdf = new SimpleDateFormat(RequestUtil.DATE_TIME_FORMAT);
            Node node = (Node)xpath.compile("message/schedule/dateTime").evaluate(xmlDoc, XPathConstants.NODE);
            if (node == null) {
                throw new Exception("Message schedule date and time node was not found.");
            }
            Date dateTime = sdf.parse(node.getTextContent());
            node = (Node)xpath.compile("message/schedule/offset").evaluate(xmlDoc, XPathConstants.NODE);
            String utcOffset = node.getTextContent();
            mc.setScheduleDateTime(dateTime, utcOffset);
            node = (Node)xpath.compile("message/sender").evaluate(xmlDoc, XPathConstants.NODE);
            if (node != null) {
                mc.setSender(node.getTextContent());
            }
            if ((node = (Node)xpath.compile("message/callback/url").evaluate(xmlDoc, XPathConstants.NODE)) != null) {
                String notifyURL = node.getTextContent();
                node = (Node)xpath.compile("message/callback/accept").evaluate(xmlDoc, XPathConstants.NODE);
                String notifyContentType = node.getTextContent();
                mc.setDeliveryCallback(notifyURL, RequestUtil.getDataContentTypeFromLabel(notifyContentType));
            }
        }
    }

    private Composer getNextMessage() throws Exception {
        while (!this._done && this._xmlReader.hasNext()) {
            int eventType = this._xmlReader.next();
            switch (eventType) {
                case 1: {
                    if (!this._xmlReader.getLocalName().equalsIgnoreCase("message")) break;
                    String messageXml = XMLUtil.readNodeOuterXML(this._xmlReader, "message");
                    return this.readMessage(messageXml);
                }
                case 2: {
                    if (!this._xmlReader.getLocalName().equalsIgnoreCase("data")) break;
                    this._done = true;
                }
            }
        }
        return null;
    }

    public MessageComposerList getMessages() throws Exception {
        Composer mc;
        MessageComposerList msgsList = new MessageComposerList();
        while ((mc = this.getNextMessage()) != null) {
            msgsList.add(mc);
        }
        return msgsList;
    }
}

