/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Build.Writer;

import Zenoph.Notify.Build.Writer.DataWriter;
import Zenoph.Notify.Collections.ComposerDestinationsList;
import Zenoph.Notify.Compose.Composer;
import Zenoph.Notify.Compose.MessageComposer;
import Zenoph.Notify.Compose.SMSComposer;
import Zenoph.Notify.Compose.USSDComposer;
import Zenoph.Notify.Compose.VoiceComposer;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Enums.DestinationMode;
import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Enums.SMSType;
import Zenoph.Notify.Store.ComposerDestination;
import Zenoph.Notify.Store.PersonalisedValues;
import Zenoph.Notify.Utils.RequestUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public final class XmlDataWriter
extends DataWriter {
    private static final String REQ_STR_TPL;
    private static final String DATA_PLACEHOLDER;
    private String _requestBody = REQ_STR_TPL;

    private XMLStreamWriter createWriter(ByteArrayOutputStream bos, boolean escapeChars) throws Exception {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        xof.setProperty("escapeCharacters", escapeChars);
        XMLStreamWriter writer = xof.createXMLStreamWriter(bos, "UTF-8");
        return writer;
    }

    private XMLStreamWriter createWriter(ByteArrayOutputStream bos) throws Exception {
        return this.createWriter(bos, false);
    }

    @Override
    public void writeUSSDRequest(USSDComposer uc, OutputStream os) throws Exception {
    }

    private void writeUSSDData(USSDComposer tmc, XMLStreamWriter writer) {
    }

    @Override
    public void writeSMSRequest(SMSComposer sc, OutputStream os) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter writer = this.createWriter(bos);
        this.writeSMSProperties(sc, writer);
        this.writeDestinations(sc, writer);
        writer.flush();
        byte[] xmlBytes = bos.toByteArray();
        bos.close();
        this._requestBody = this._requestBody.replace(DATA_PLACEHOLDER, new String(xmlBytes));
        this.writeRequestData(this._requestBody, os);
    }

    private void writeSMSProperties(SMSComposer tmc, XMLStreamWriter xmlWriter) throws Exception {
        String messageText = tmc.getMessage();
        SMSType msgType = tmc.getSMSType();
        xmlWriter.writeStartElement("text");
        xmlWriter.writeCharacters(messageText);
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("type");
        xmlWriter.writeCharacters(Integer.toString(msgType.getId()));
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement("sender");
        xmlWriter.writeCharacters(tmc.getSender());
        xmlWriter.writeEndElement();
        if (SMSComposer.getMessageVariablesCount(messageText) > 0) {
            xmlWriter.writeStartElement("personalise");
            xmlWriter.writeCharacters(tmc.personalise() ? "true" : "false");
            xmlWriter.writeEndElement();
        }
        this.writeCommonMessageProperties(tmc, xmlWriter);
    }

    @Override
    public void writeVoiceRequest(VoiceComposer vc, OutputStream os) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter xmlWriter = this.createWriter(bos);
        this.writeVoiceProperties(vc, xmlWriter);
        this.writeDestinations(vc, xmlWriter);
        xmlWriter.flush();
        byte[] dataBytes = bos.toByteArray();
        bos.close();
        this._requestBody = this._requestBody.replace(DATA_PLACEHOLDER, new String(dataBytes));
        this.writeRequestData(this._requestBody, os);
    }

    private void writeVoiceProperties(VoiceComposer vmc, XMLStreamWriter xmlWriter) throws Exception {
        if (vmc.isOfflineVoice()) {
            throw new Exception("Unsupported data writer for writing offline voice data.");
        }
        String sender = vmc.getSender();
        String tplRef = vmc.getTemplateReference();
        if (!vmc.isOfflineVoice() && (tplRef == null || tplRef.isEmpty())) {
            throw new Exception("Template reference has not been set for writing voice message data.");
        }
        if (sender != null && !sender.isEmpty()) {
            xmlWriter.writeStartElement("sender");
            xmlWriter.writeCharacters(sender);
            xmlWriter.writeEndElement();
        }
        if (tplRef != null && !tplRef.isEmpty()) {
            xmlWriter.writeStartElement("template");
            xmlWriter.writeCharacters(tplRef);
            xmlWriter.writeEndElement();
        }
        this.writeCommonMessageProperties(vmc, xmlWriter);
    }

    @Override
    protected void writeCommonMessageProperties(MessageComposer mc, Object res) throws Exception {
        if (res == null || !(res instanceof XMLStreamWriter)) {
            throw new Exception("Invalid storage object for writing common message properties.");
        }
        XMLStreamWriter xmlWriter = (XMLStreamWriter)res;
        if (mc instanceof MessageComposer && mc.schedule()) {
            Object[] schedInfo = mc.getScheduleInfo();
            this.writeScheduleInfo((Date)schedInfo[0], (String)schedInfo[1], xmlWriter);
        }
        if (mc.notifyDeliveries()) {
            Object[] notifyInfo = mc.getDeliveryCallback();
            this.writeCallbackInfo((String)notifyInfo[0], (ContentType)((Object)notifyInfo[1]), xmlWriter);
        }
    }

    @Override
    protected void writeScheduleInfo(Date dateTime, String utcOffset, Object store) throws Exception {
        this.validateScheduleInfo(dateTime, utcOffset);
        XMLStreamWriter writer = (XMLStreamWriter)store;
        writer.writeStartElement("schedule");
        writer.writeStartElement("dateTime");
        writer.writeCharacters(this.dateTimeToStr(dateTime));
        writer.writeEndElement();
        if (utcOffset != null && !utcOffset.isEmpty()) {
            writer.writeStartElement("offset");
            writer.writeCharacters(utcOffset);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    protected void writeCallbackInfo(String url, ContentType accept, Object store) throws Exception {
        this.validateDeliveryNotificationInfo(url, accept);
        XMLStreamWriter writer = (XMLStreamWriter)store;
        writer.writeStartElement("callback");
        writer.writeStartElement("url");
        writer.writeCharacters(url);
        writer.writeEndElement();
        writer.writeStartElement("accept");
        writer.writeCharacters(RequestUtil.getDataContentTypeLabel(accept));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Override
    public void writeDestinationsData(Composer mc, OutputStream os) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid reference to message object for writing destinations.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter xmlWriter = this.createWriter(bos);
        this.writeDestinations(mc, xmlWriter);
        xmlWriter.flush();
        byte[] dataBytes = bos.toByteArray();
        bos.close();
        this._requestBody = this._requestBody.replace(DATA_PLACEHOLDER, new String(dataBytes));
        this.writeRequestData(this._requestBody, os);
    }

    @Override
    protected void writeDestinations(Composer mc, Object store) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid reference to container object for writing message destinations data.");
        }
        if (store == null || !(store instanceof XMLStreamWriter)) {
            throw new Exception("Invalid store object for writing message destinations data.");
        }
        ComposerDestinationsList dests = mc.getDestinations();
        if (dests.getCount() == 0) {
            throw new Exception("There are no destinations for writing.");
        }
        XMLStreamWriter xmlWriter = (XMLStreamWriter)store;
        xmlWriter.writeStartElement("destinations");
        for (ComposerDestination cd : dests) {
            if (cd.getWriteMode() == DestinationMode.DM_NONE) continue;
            String destination = cd.getPhoneNumber();
            if (mc instanceof MessageComposer) {
                ((MessageComposer)mc).validateDestinationSenderName(destination);
            }
            String messageId = cd.getMessageId();
            Object destData = cd.getData();
            this.writeDestinationItem(destination, messageId, destData, xmlWriter);
        }
        xmlWriter.writeEndElement();
    }

    private void writeDestinationItem(String phoneNumber, String messageId, Object data, XMLStreamWriter xmlWriter) throws Exception {
        if ((phoneNumber == null || phoneNumber.isEmpty()) && (messageId == null || messageId.isEmpty())) {
            throw new Exception("Both destination and message identifier cannot be null for writing destination item info.");
        }
        xmlWriter.writeStartElement("to");
        if (messageId == null && data == null) {
            xmlWriter.writeCharacters(phoneNumber);
        } else {
            this.writeDestinationItemWithData(phoneNumber, messageId, data, xmlWriter);
        }
        xmlWriter.writeEndElement();
    }

    private void writeDestinationItemWithData(String destination, String messageId, Object data, XMLStreamWriter xmlWriter) throws Exception {
        if (messageId != null && !messageId.isEmpty()) {
            xmlWriter.writeStartElement("id");
            xmlWriter.writeCharacters(messageId);
            xmlWriter.writeEndElement();
        }
        if (destination != null && !destination.isEmpty()) {
            xmlWriter.writeStartElement("number");
            xmlWriter.writeCharacters(destination);
            xmlWriter.writeEndElement();
        }
        if (data instanceof PersonalisedValues) {
            this.writeDestinationPersonalisedValues((PersonalisedValues)data, xmlWriter);
        }
    }

    private void writeDestinationPersonalisedValues(PersonalisedValues pv, XMLStreamWriter xmlWriter) throws Exception {
        xmlWriter.writeStartElement("values");
        for (String value : pv.export()) {
            xmlWriter.writeStartElement("value");
            xmlWriter.writeCharacters(value);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    @Override
    public void writeDestinationsDeliveryRequest(List<String> messageIds, OutputStream os) throws Exception {
        if (messageIds == null || messageIds.isEmpty()) {
            throw new Exception("Invalid or no destination identifiers for writing destinations delivery request data.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter xmlWriter = this.createWriter(bos);
        xmlWriter.writeStartElement("destinations");
        for (int i = 0; i < messageIds.size(); ++i) {
            String id = messageIds.get(i);
            if (id == null || id.isEmpty()) {
                throw new Exception(String.format("Invalid message identifier at index '%d'.", i));
            }
            xmlWriter.writeStartElement("id");
            xmlWriter.writeCharacters(id);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        xmlWriter.flush();
        byte[] dataBytes = bos.toByteArray();
        bos.close();
        this._requestBody = this._requestBody.replace(DATA_PLACEHOLDER, new String(dataBytes));
        this.writeRequestData(this._requestBody, os);
    }

    @Override
    public void writeScheduledMessagesLoadRequest(HashMap<String, Object> data, OutputStream os) throws Exception {
        this.validateScheduledMessagesLoadData(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter xmlWriter = this.createWriter(bos);
        String batchId = (String)data.get("batch");
        if (batchId != null && !batchId.isEmpty()) {
            this.writeMessageBatchId(batchId, xmlWriter);
        } else {
            if (data.get("category") != null) {
                xmlWriter.writeStartElement("category");
                xmlWriter.writeCharacters(Integer.toString(((MessageCategory)((Object)data.get("category"))).getId()));
                xmlWriter.writeEndElement();
            }
            if (data.get("dateFrom") != null && data.get("dateTo") != null) {
                Date dateFrom = (Date)data.get("dateFrom");
                Date dateTo = (Date)data.get("dateTo");
                xmlWriter.writeStartElement("dateTime");
                xmlWriter.writeStartElement("from");
                xmlWriter.writeCharacters(this.dateTimeToStr(dateFrom));
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("to");
                xmlWriter.writeCharacters(this.dateTimeToStr(dateTo));
                xmlWriter.writeEndElement();
                String utcOffset = data.get("offset").toString();
                if (utcOffset != null && !utcOffset.isEmpty()) {
                    xmlWriter.writeStartElement("offset");
                    xmlWriter.writeCharacters(utcOffset);
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeEndElement();
            }
        }
        xmlWriter.flush();
        byte[] dataBytes = bos.toByteArray();
        bos.close();
        this._requestBody = this._requestBody.replace(DATA_PLACEHOLDER, new String(dataBytes));
        this.writeRequestData(this._requestBody, os);
    }

    @Override
    public void writeScheduledMessageUpdateRequest(Composer mc, OutputStream os) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid object reference for writing scheduled message update data.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter xmlWriter = this.createWriter(bos, false);
        MessageCategory category = mc.getCategory();
        if (category == MessageCategory.SMS || category == MessageCategory.USSD) {
            this.writeSMSProperties((SMSComposer)mc, xmlWriter);
        } else {
            this.writeVoiceProperties((VoiceComposer)mc, xmlWriter);
        }
        if (mc.getDestinationsCount() > 0) {
            this.writeScheduledMessageDestinations(mc, xmlWriter);
        }
        xmlWriter.flush();
        byte[] dataBytes = bos.toByteArray();
        bos.close();
        this._requestBody = this._requestBody.replace(DATA_PLACEHOLDER, new String(dataBytes));
        this.writeRequestData(this._requestBody, os);
    }

    private void writeScheduledMessageDestinations(Composer mc, XMLStreamWriter xmlWriter) throws Exception {
        ComposerDestinationsList dests = mc.getDestinations();
        if (dests == null || dests.isEmpty()) {
            return;
        }
        ByteArrayOutputStream addBos = new ByteArrayOutputStream();
        ByteArrayOutputStream updateBos = new ByteArrayOutputStream();
        ByteArrayOutputStream deleteBos = new ByteArrayOutputStream();
        XMLStreamWriter addWriter = this.createWriter(addBos);
        XMLStreamWriter updateWriter = this.createWriter(updateBos);
        XMLStreamWriter deleteWriter = this.createWriter(deleteBos);
        for (ComposerDestination cd : dests) {
            DestinationMode destMode = cd.getWriteMode();
            if (destMode == DestinationMode.DM_NONE) continue;
            String phoneNumber = cd.getPhoneNumber();
            ((MessageComposer)mc).validateDestinationSenderName(phoneNumber);
            String messageId = cd.getMessageId();
            Object destData = cd.getData();
            switch (destMode) {
                case DM_ADD: {
                    this.writeDestinationItem(phoneNumber, messageId, destData, addWriter);
                    break;
                }
                case DM_UPDATE: {
                    this.writeDestinationItem(phoneNumber, messageId, destData, updateWriter);
                    break;
                }
                case DM_DELETE: {
                    this.writeDestinationItem(null, messageId, null, deleteWriter);
                }
            }
        }
        addWriter.flush();
        updateWriter.flush();
        deleteWriter.flush();
        String addXml = new String(addBos.toByteArray());
        String updateXml = new String(updateBos.toByteArray());
        String deleteXml = new String(deleteBos.toByteArray());
        xmlWriter.writeStartElement("destinations");
        if (!addXml.isEmpty()) {
            xmlWriter.writeStartElement("add");
            xmlWriter.writeCharacters(addXml);
            xmlWriter.writeEndElement();
        }
        if (!updateXml.isEmpty()) {
            xmlWriter.writeStartElement("update");
            xmlWriter.writeCharacters(updateXml);
            xmlWriter.writeEndElement();
        }
        if (!deleteXml.isEmpty()) {
            xmlWriter.writeStartElement("delete");
            xmlWriter.writeCharacters(deleteXml);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        addBos.close();
        updateBos.close();
        deleteBos.close();
    }

    private void writeMessageBatchId(String batchId, XMLStreamWriter xmlWriter) throws Exception {
        xmlWriter.writeStartElement("batch");
        xmlWriter.writeCharacters(batchId);
        xmlWriter.writeEndElement();
    }

    static {
        DATA_PLACEHOLDER = "__%dataPH%__";
        REQ_STR_TPL = String.format("<request>%s</request>", DATA_PLACEHOLDER);
    }
}

