/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Compose;

import Zenoph.Notify.Collections.ComposerDestinationsList;
import Zenoph.Notify.Compose.IComposer;
import Zenoph.Notify.Enums.DestinationMode;
import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Enums.NumberAddInfo;
import Zenoph.Notify.Store.AuthProfile;
import Zenoph.Notify.Store.ComposerDestination;
import Zenoph.Notify.Store.UserData;
import Zenoph.Notify.Utils.MessageUtil;
import Zenoph.Notify.Utils.PhoneUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Composer
implements IComposer {
    protected UserData _userData;
    protected List<ComposerDestination> _destinations;
    protected HashMap<String, ComposerDestination> _destIdsMap;
    protected HashMap<String, HashMap<String, Object>> _destNumbersMap;
    MessageCategory _category;
    public static final String CUSTOM_DATA_LABEL = "data";
    protected static final String __DEST_INFO_LABEL__ = "destInfo";
    protected static final String __DEST_COUNTRYCODE_LABEL__ = "countryCode";

    public Composer() {
        this.initCommonData();
    }

    public Composer(AuthProfile ap) throws Exception {
        if (ap == null) {
            throw new Exception("Invalid client data for initialising message object.");
        }
        if (!ap.authenticated()) {
            throw new Exception("User profile has not been authenticated.");
        }
        this._userData = ap.getUserData();
        this.initCommonData();
    }

    private void initCommonData() {
        this._destIdsMap = new HashMap();
        this._destNumbersMap = new HashMap();
        this._destinations = new ArrayList<ComposerDestination>();
    }

    public void setUserData(UserData ud) throws Exception {
        if (ud == null) {
            throw new Exception("Invalid user data object.");
        }
        this._userData = ud;
    }

    @Override
    public int getDestinationsCount() {
        return this._destinations.size();
    }

    @Override
    public MessageCategory getCategory() throws Exception {
        return this._category;
    }

    @Override
    public String getDestinationCountry(String phoneNumber) throws Exception {
        if (this._userData == null) {
            return null;
        }
        if (!this.destinationExists(phoneNumber)) {
            return null;
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber, false);
        String fmtdNumber = numberInfo.get("number");
        String countryCode = this.getDestinationCountryCode(fmtdNumber);
        if (countryCode == null || countryCode.isEmpty()) {
            return null;
        }
        HashMap<String, HashMap<String, Object>> filters = this._userData.getRouteFilters();
        if (!filters.containsKey(countryCode)) {
            return null;
        }
        return filters.get(countryCode).get("countryName").toString();
    }

    @Override
    public String[] getDefaultTimeZone() throws Exception {
        if (this._userData == null) {
            return null;
        }
        return this._userData.getDefaultTimeZone();
    }

    @Override
    public DestinationMode getDestinationWriteMode(String phoneNumber) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for destination mode.");
        }
        if (!this.destinationExists(phoneNumber)) {
            throw new Exception(String.format("Phone number '%s' does not exist in destinations list.", phoneNumber));
        }
        HashMap<String, String> numInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numInfo.get("number");
        List<ComposerDestination> destInfoList = this.getMappedDestinations(fmtdNumber);
        if (destInfoList.size() > 1) {
            throw new Exception("There are multiple destination data information.");
        }
        return destInfoList.get(0).getWriteMode();
    }

    @Override
    public DestinationMode getDestinationWriteModeById(String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid message identifier for getting destination mode.");
        }
        if (!this._destIdsMap.containsKey(messageId)) {
            throw new Exception(String.format("Message identifier '%s' does not exist.", messageId));
        }
        return this._destIdsMap.get(messageId).getWriteMode();
    }

    @Override
    public String[] getDefaultDestinationCountry() throws Exception {
        if (this._userData == null) {
            throw new Exception("Default destination country has not been loaded.");
        }
        HashMap<String, Object> defRouteInfo = this._userData.getDefaultRouteInfo();
        String countryName = defRouteInfo.get("countryName").toString();
        String countryCode = defRouteInfo.get("countryCode").toString();
        String dialCode = defRouteInfo.get("dialCode").toString();
        return new String[]{countryName, countryCode, dialCode};
    }

    protected String getDestinationCountryCode(String phoneNumber) throws Exception {
        String countryCode;
        if (this.formattedDestinationExists(phoneNumber)) {
            countryCode = (String)this._destNumbersMap.get(phoneNumber).get(__DEST_COUNTRYCODE_LABEL__);
        } else {
            HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber, false);
            if (numberInfo == null) {
                return null;
            }
            countryCode = numberInfo.get(__DEST_COUNTRYCODE_LABEL__);
        }
        return countryCode;
    }

    @Override
    public int addDestinationsFromTextStream(String str) throws Exception {
        if (str == null || str.isEmpty()) {
            throw new Exception("Invalid text stream for adding message destinations.");
        }
        int addedCount = 0;
        List<String> validList = PhoneUtil.extractPhoneNumbers(str);
        if (validList != null) {
            addedCount = this.addDestinationsFromCollection(validList, false);
        }
        return addedCount;
    }

    @Override
    public int addDestinationsFromCollection(String[] phoneNumbers) throws Exception {
        return this.addDestinationsFromCollection(phoneNumbers, false);
    }

    @Override
    public int addDestinationsFromCollection(String[] phoneNumbers, boolean throwEx) throws Exception {
        if (phoneNumbers == null) {
            if (!throwEx) {
                return 0;
            }
            throw new Exception("Invalid collection for adding destinations.");
        }
        int count = 0;
        for (String phoneNum : phoneNumbers) {
            if (this.addDestination(phoneNum, throwEx) != NumberAddInfo.NAI_OK) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addDestinationsFromCollection(List<String> phoneNumbers) throws Exception {
        return this.addDestinationsFromCollection(phoneNumbers, false);
    }

    @Override
    public int addDestinationsFromCollection(List<String> phoneNumbers, boolean throwEx) throws Exception {
        if (phoneNumbers == null) {
            if (!throwEx) {
                return 0;
            }
            throw new Exception("Invalid collection for adding destinations.");
        }
        int count = 0;
        for (String phoneNum : phoneNumbers) {
            if (this.addDestination(phoneNum, throwEx) != NumberAddInfo.NAI_OK) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<String[]> getRouteCountries() throws Exception {
        if (this._userData == null) {
            return null;
        }
        return this._userData.getRouteCountries();
    }

    protected boolean formattedDestinationExists(String phoneNumber) {
        if (this._destNumbersMap == null || this._destNumbersMap.isEmpty()) {
            return false;
        }
        return this._destNumbersMap.containsKey(phoneNumber);
    }

    @Override
    public boolean destinationExists(String phoneNumber) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to phone number for verifying destination existence.");
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        if (numberInfo == null) {
            return false;
        }
        return this.formattedDestinationExists(numberInfo.get("number"));
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber) throws Exception {
        return this.addDestination(phoneNumber, true);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid custom message identifier for destination.");
        }
        this.validateCustomMessageId(messageId, true);
        return this.addDestination(phoneNumber, true, messageId);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx) throws Exception {
        return this.addDestination(phoneNumber, throwEx, null);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx, String messageId) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_INVALID;
            }
            throw new Exception("Invalid value for adding message destination.");
        }
        if (!PhoneUtil.isValidPhoneNumber(phoneNumber)) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_INVALID;
            }
            throw new Exception(String.format("'%s' is not a valid phone number.", phoneNumber));
        }
        NumberAddInfo NAI = this.validateCustomMessageId(messageId, throwEx);
        if (NAI != NumberAddInfo.NAI_OK) {
            return NAI;
        }
        HashMap<String, String> fmtdNumberInfo = this.formatPhoneNumber(phoneNumber);
        if (fmtdNumberInfo == null) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_ROUTE;
            }
            throw new Exception(String.format("'%s' is not a valid destination on permitted routes.", phoneNumber));
        }
        String fmtdPhoneNumber = fmtdNumberInfo.get("number");
        if (this.formattedDestinationExists(fmtdPhoneNumber)) {
            if (!throwEx) {
                return NumberAddInfo.NAI_REJTD_EXISTS;
            }
            throw new Exception(String.format("Phone number '%s' already exists.", phoneNumber));
        }
        return this.addDestination(fmtdPhoneNumber, fmtdNumberInfo.get(__DEST_COUNTRYCODE_LABEL__), messageId, null);
    }

    protected void addDestination(ComposerDestination cd, String countryCode) throws Exception {
        this.addDestination(cd);
        String destination = cd.getPhoneNumber();
        if (this._destNumbersMap.containsKey(destination)) {
            HashMap<String, Object> hm = this._destNumbersMap.get(destination);
            List diList = (List)hm.get(__DEST_INFO_LABEL__);
            diList.add(cd);
        } else {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            ArrayList<ComposerDestination> diList = new ArrayList<ComposerDestination>();
            diList.add(cd);
            hm.put(__DEST_COUNTRYCODE_LABEL__, countryCode);
            hm.put(__DEST_INFO_LABEL__, diList);
            this._destNumbersMap.put(destination, hm);
        }
    }

    protected void addDestination(ComposerDestination cd) throws Exception {
        String messageId = cd.getMessageId();
        if (messageId != null && !messageId.isEmpty()) {
            if (this._destIdsMap.containsKey(messageId)) {
                throw new Exception(String.format("Message identifier '%s' already exists.", messageId));
            }
            this._destIdsMap.put(messageId, cd);
        }
        this._destinations.add(cd);
    }

    protected void addDestinationsList(List<ComposerDestination> compDestList, String countryCode) throws Exception {
        if (compDestList == null) {
            throw new Exception("Invalid reference for adding composer destinations collection.");
        }
        for (ComposerDestination cd : compDestList) {
            this.addDestination(cd, countryCode);
        }
    }

    protected NumberAddInfo addDestination(String phoneNumber, String countryCode, String messageId, Object data) throws Exception {
        ComposerDestination di = this.createComposerDestination(phoneNumber, messageId, DestinationMode.DM_ADD, data);
        this.addDestination(di, countryCode);
        return NumberAddInfo.NAI_OK;
    }

    protected ComposerDestination createComposerDestination(String phoneNumber, String msgId, DestinationMode mode, Object data) throws Exception {
        return this.createComposerDestination(phoneNumber, msgId, mode, data, false);
    }

    protected ComposerDestination createComposerDestination(String phoneNumber, String messageId, DestinationMode mode, Object data, boolean scheduled) throws Exception {
        HashMap<String, Object> hm = this.createDestinationMap(phoneNumber, messageId, mode, data, scheduled);
        ComposerDestination di = ComposerDestination.create(hm);
        return di;
    }

    protected HashMap<String, Object> createDestinationMap(String phoneNumber, String messageId, DestinationMode mode, Object data, boolean scheduled) throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("phoneNumber", phoneNumber);
        hm.put("messageId", messageId);
        hm.put("destMode", (Object)mode);
        hm.put("data", data);
        hm.put("scheduled", scheduled);
        return hm;
    }

    protected boolean removeDestination(ComposerDestination cd) throws Exception {
        if (this._destinations.contains(cd)) {
            String messageId = cd.getMessageId();
            String phoneNumber = cd.getPhoneNumber();
            if (messageId != null && !messageId.isEmpty() && this._destIdsMap.containsKey(messageId)) {
                this._destIdsMap.remove(messageId);
            }
            List<ComposerDestination> compDestList = this.getMappedDestinations(phoneNumber);
            compDestList.remove(cd);
            if (compDestList.isEmpty()) {
                this._destNumbersMap.remove(phoneNumber);
            }
            this._destinations.remove(cd);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeDestination(String phoneNumber) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for removing message destination.");
        }
        if (!this.destinationExists(phoneNumber)) {
            throw new Exception(String.format("Phone number '%s' does not exist.", phoneNumber));
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        String fmtdNumber = numberInfo.get("number");
        List<ComposerDestination> destInfoList = this.getMappedDestinations(fmtdNumber);
        this.removeDestinationsList(fmtdNumber, destInfoList);
        return true;
    }

    @Override
    public boolean removeDestinationById(String destId) throws Exception {
        if (destId == null || destId.isEmpty()) {
            throw new Exception("Invalid message identifier for removing destination.");
        }
        if (!this.destinationIdExists(destId)) {
            throw new Exception(String.format("Message identifier '%s' does not exist.", destId));
        }
        ComposerDestination cd = this.getComposerDestinationById(destId);
        return this.removeDestination(cd);
    }

    protected boolean destinationIdExists(String destId) throws Exception {
        if (destId == null || destId.isEmpty()) {
            throw new Exception("Invalid reference for verifying message identifier.");
        }
        return this._destIdsMap.containsKey(destId);
    }

    protected void removeDestinationsList(String phoneNumber, List<ComposerDestination> destsList) throws Exception {
        if (destsList.size() > 0) {
            ArrayList<ComposerDestination> replaceList = new ArrayList<ComposerDestination>();
            String countryCode = this.getDestinationCountryCode(phoneNumber);
            int count = destsList.size();
            while (count > 0) {
                ComposerDestination compDest;
                if ((compDest = destsList.get(--count)).isScheduled()) {
                    String destination = compDest.getPhoneNumber();
                    String messageId = compDest.getMessageId();
                    Object data = compDest.getData();
                    DestinationMode mode = DestinationMode.DM_DELETE;
                    ComposerDestination newCompDest = this.createComposerDestination(destination, messageId, mode, data, true);
                    replaceList.add(newCompDest);
                }
                this.removeDestination(compDest);
            }
            if (replaceList.size() > 0) {
                this.addDestinationsList(replaceList, countryCode);
            }
        }
    }

    protected List<ComposerDestination> getDestinationInfoContainerById(String messageId) throws Exception {
        ComposerDestination di = this._destIdsMap.get(messageId);
        String phoneNumber = di.getPhoneNumber();
        return this.getMappedDestinations(phoneNumber);
    }

    protected List<ComposerDestination> getMappedDestinations(String fmtdPhoneNumber) throws Exception {
        if (fmtdPhoneNumber == null || fmtdPhoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for destination data container.");
        }
        if (!this._destNumbersMap.containsKey(fmtdPhoneNumber)) {
            throw new Exception(String.format("'%s' does not exist in the destinations list.", fmtdPhoneNumber));
        }
        return (List)this._destNumbersMap.get(fmtdPhoneNumber).get(__DEST_INFO_LABEL__);
    }

    protected ComposerDestination getMappedDestinationById(String destId) throws Exception {
        if (destId == null || destId.isEmpty()) {
            throw new Exception("Invalid message identifier for composer destination.");
        }
        if (!this.destinationIdExists(destId)) {
            throw new Exception(String.format("Message identifier '%s' does not exist.", destId));
        }
        return this._destIdsMap.get(destId);
    }

    protected ComposerDestination getComposerDestinationById(String messageId) throws Exception {
        return this.getMappedDestinationById(messageId);
    }

    protected List<ComposerDestination> getComposerDestinations(String phoneNumber) throws Exception {
        return this.getMappedDestinations(phoneNumber);
    }

    protected NumberAddInfo validateCustomMessageId(String messageId, boolean throwEx) throws Exception {
        if (messageId != null && !messageId.isEmpty()) {
            if (this._destIdsMap.containsKey(messageId)) {
                if (!throwEx) {
                    return NumberAddInfo.NAI_REJTD_MSGID_EXISTS;
                }
                throw new Exception(String.format("Message identifier '%s' already exists.", messageId));
            }
            if (messageId.length() < MessageUtil.CUSTOM_MSGID_MIN_LEN || messageId.length() > MessageUtil.CUSTOM_MSGID_MAX_LEN) {
                if (!throwEx) {
                    return NumberAddInfo.NAI_REJTD_MSGID_LENGTH;
                }
                throw new Exception("Invalid length of message identifier.");
            }
            if (!MessageUtil.isRegexMatch(String.format("[%s]{%s,}", "A-Za-z0-9-", MessageUtil.CUSTOM_MSGID_MIN_LEN), messageId)) {
                if (!throwEx) {
                    return NumberAddInfo.NAI_REJTD_MSGID_INVALID;
                }
                throw new Exception(String.format("Message identifier '%s' is not in the correct format.", messageId));
            }
        }
        return NumberAddInfo.NAI_OK;
    }

    @Override
    public ComposerDestinationsList getDestinations() throws Exception {
        return new ComposerDestinationsList(this._destinations);
    }

    protected HashMap<String, String> formatPhoneNumber(String phoneNumber, boolean throwEx) throws Exception {
        if (this._userData == null) {
            return UserData.createDestinationCountryMap(phoneNumber, null);
        }
        return this._userData.formatPhoneNumber(phoneNumber, throwEx);
    }

    protected String getFormattedPhoneNumber(String phoneNumber) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to phone number for destination message identifier.");
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        if (numberInfo == null) {
            throw new Exception("Invalid or unsupported phone number.");
        }
        return numberInfo.get("number");
    }

    protected HashMap<String, String> formatPhoneNumber(String phoneNumber) throws Exception {
        return this.formatPhoneNumber(phoneNumber, false);
    }

    @Override
    public void clearDestinations() {
        this._destIdsMap.clear();
        this._destinations.clear();
        this._destNumbersMap.clear();
    }

    @Override
    public void setDefaultNumberPrefix(String dialCode) throws Exception {
        if (this._userData == null) {
            throw new Exception("Authentication request has not been performed.");
        }
        this._userData.setDefaultDialCode(dialCode);
    }

    @Override
    public String getDefaultNumberPrefix() {
        return this._userData == null ? null : this._userData.getDefaultDialCode();
    }

    protected HashMap<String, Object> validateDestinationUpdate(String prePhoneNumber, String newPhoneNumber) throws Exception {
        if (prePhoneNumber == null || prePhoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to previous phone number for updating destination.");
        }
        if (newPhoneNumber == null || prePhoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to new phone number for updating destination.");
        }
        HashMap<String, String> preNumInfo = this.formatPhoneNumber(prePhoneNumber);
        HashMap<String, String> newNumInfo = this.formatPhoneNumber(newPhoneNumber);
        if (preNumInfo == null) {
            throw new Exception("Invalid or unsupported previous phone number for updating destination.");
        }
        if (newNumInfo == null) {
            throw new Exception("Invalid or unsupported new phone number for updating destination.");
        }
        HashMap<String, Object> numInfoData = new HashMap<String, Object>();
        numInfoData.put("pre", preNumInfo);
        numInfoData.put("new", newNumInfo);
        return numInfoData;
    }

    @Override
    public boolean updateDestinationById(String destId, String newPhoneNumber) throws Exception {
        if (destId == null || destId.isEmpty()) {
            throw new Exception("Invalid message identifier for updating destination.");
        }
        if (!this.destinationIdExists(destId)) {
            throw new Exception(String.format("Message Id '%s' does not exist.", destId));
        }
        if (newPhoneNumber == null || newPhoneNumber.isEmpty() || !PhoneUtil.isValidPhoneNumber(newPhoneNumber)) {
            throw new Exception("Invalid phone number for updating destination.");
        }
        HashMap<String, String> numInfo = this.formatPhoneNumber(newPhoneNumber);
        if (numInfo != null) {
            ComposerDestination cd = this.getComposerDestinationById(destId);
            return this.updateDestination(cd, numInfo.get("number"));
        }
        return false;
    }

    @Override
    public boolean updateDestination(String prePhoneNumber, String newPhoneNumber) throws Exception {
        HashMap<String, Object> numInfoData = this.validateDestinationUpdate(prePhoneNumber, newPhoneNumber);
        String preFmtdNumber = (String)((HashMap)numInfoData.get("pre")).get("number");
        String newFmtdNumber = (String)((HashMap)numInfoData.get("new")).get("number");
        List<ComposerDestination> destsList = this.getMappedDestinations(preFmtdNumber);
        if (destsList.size() > 0) {
            int count = destsList.size();
            while (count > 0) {
                ComposerDestination compDest = destsList.get(--count);
                this.updateDestination(compDest, newFmtdNumber);
            }
            return true;
        }
        return false;
    }

    protected boolean updateDestination(ComposerDestination cd, String newPhoneNumber) throws Exception {
        HashMap<String, String> numInfo = this.formatPhoneNumber(newPhoneNumber);
        String countryCode = numInfo.get("countryCode");
        Object destData = cd.getData();
        String messageId = cd.getMessageId();
        boolean scheduled = cd.isScheduled();
        DestinationMode destMode = cd.getWriteMode();
        if (scheduled) {
            destMode = DestinationMode.DM_UPDATE;
        }
        ComposerDestination newCompDest = this.createComposerDestination(newPhoneNumber, messageId, destMode, destData, scheduled);
        if (this.removeDestination(cd)) {
            this.addDestination(newCompDest, countryCode);
            return true;
        }
        return false;
    }

    protected String getPhoneNumberFromMessageId(String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid message identifier for getting destination phone number.");
        }
        if (!this._destIdsMap.containsKey(messageId)) {
            throw new Exception(String.format("Message identifier '%s' does not exist.", messageId));
        }
        return this._destIdsMap.get(messageId).getPhoneNumber();
    }
}

