/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Compose;

import Zenoph.Notify.Build.Reader.MessageDestinationsReader;
import Zenoph.Notify.Collections.MessageDestinationsList;
import Zenoph.Notify.Compose.Composer;
import Zenoph.Notify.Compose.IMessageComposer;
import Zenoph.Notify.Compose.ISchedule;
import Zenoph.Notify.Compose.Schedule;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Enums.DestinationMode;
import Zenoph.Notify.Enums.DestinationStatus;
import Zenoph.Notify.Store.AuthProfile;
import Zenoph.Notify.Store.ComposerDestination;
import Zenoph.Notify.Store.MessageDestination;
import Zenoph.Notify.Utils.MessageUtil;
import Zenoph.Notify.Utils.PhoneUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public abstract class MessageComposer
extends Composer
implements IMessageComposer,
ISchedule {
    protected String _sender;
    protected String _batchId;
    protected Schedule _scheduler;
    boolean _isScheduled;
    protected String _message;
    protected String _delivCallbackURL;
    protected ContentType _delivCallbackAccept;

    public MessageComposer() {
        this.init();
    }

    public MessageComposer(AuthProfile ap) throws Exception {
        super(ap);
        this.init();
    }

    private void init() {
        this._scheduler = new Schedule();
        this._isScheduled = false;
        this._sender = null;
        this._batchId = null;
        this._delivCallbackURL = null;
        this._message = null;
        this._delivCallbackAccept = ContentType.XML;
    }

    @Override
    public String getSender() {
        return this._sender;
    }

    @Override
    public void setSender(String sender) throws Exception {
        if (sender == null || sender.isEmpty()) {
            throw new Exception("Missing or invalid message sender identifier.");
        }
        this._sender = sender;
    }

    @Override
    public String getBatchId() {
        return this._batchId;
    }

    @Override
    public Object[] getScheduleInfo() {
        Date dateTime = this._scheduler.getDateTime();
        String offset = this._scheduler.getUTCOffset();
        return new Object[]{dateTime, offset};
    }

    @Override
    public Object[] getDeliveryCallback() {
        return new Object[]{this._delivCallbackURL, this._delivCallbackAccept};
    }

    @Override
    public void setDeliveryCallback(String url, ContentType contentType) throws Exception {
        if (url == null || url.isEmpty()) {
            this._delivCallbackURL = "";
            return;
        }
        if (contentType != ContentType.XML && contentType != ContentType.JSON && contentType != ContentType.WWW_URL_ENCODED) {
            throw new Exception("Invalid data content format specifier for delivery status notifications.");
        }
        this._delivCallbackURL = url;
        this._delivCallbackAccept = contentType;
    }

    @Override
    public boolean notifyDeliveries() {
        return this._delivCallbackURL != null && !this._delivCallbackURL.isEmpty();
    }

    @Override
    public boolean schedule() {
        return this._scheduler.getDateTime() != null;
    }

    @Override
    public boolean isScheduled() throws Exception {
        return this._isScheduled;
    }

    @Override
    public void setMessage(String message) throws Exception {
        if (message == null || message.isEmpty()) {
            throw new Exception("Invalid message text or label.");
        }
        this._message = message;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    @Override
    public String getMessageId(String phoneNumber) throws Exception {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            throw new Exception("Invalid phone number for destination message identifier.");
        }
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        if (numberInfo == null) {
            return null;
        }
        String fmtdNumber = numberInfo.get("number");
        if (!this.formattedDestinationExists(fmtdNumber)) {
            throw new Exception(String.format("Destination '%s' does not exist in the message destinations list.", phoneNumber));
        }
        List<ComposerDestination> destInfoList = this.getMappedDestinations(fmtdNumber);
        if (destInfoList.size() > 1) {
            throw new Exception(String.format("There are multiple composer destinations for phone number '%s'.", fmtdNumber));
        }
        return destInfoList.get(0).getMessageId();
    }

    @Override
    public boolean messageIdExists(String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid reference for verifying message identifier.");
        }
        return this.destinationIdExists(messageId);
    }

    public static int populateScheduledDestinations(MessageComposer mc, Object data) throws Exception {
        if (mc == null) {
            throw new Exception("Invalid message object reference for populating scheduled destinations.");
        }
        if (!mc.isScheduled()) {
            throw new Exception("Message has not been scheduled for populating destinations.");
        }
        if (data == null || !(data instanceof String) || ((String)data).isEmpty()) {
            throw new Exception("Invalid data for populating message destinations.");
        }
        mc.clearDestinations();
        return MessageComposer.readScheduledDestinations(mc, data);
    }

    private static int readScheduledDestinations(Composer mc, Object data) throws Exception {
        MessageDestination md;
        MessageDestinationsReader dr = new MessageDestinationsReader();
        dr.setData(data);
        int destsCount = 0;
        while ((md = dr.getNextItem()) != null) {
            String messageId = md.getMessageId();
            String phoneNumber = md.getPhoneNumber();
            Object destData = md.getData();
            DestinationMode destMode = DestinationMode.DM_NONE;
            ComposerDestination compDest = mc.createComposerDestination(phoneNumber, messageId, destMode, destData, true);
            String countryCode = null;
            HashMap<String, String> numberInfo = mc.formatPhoneNumber(phoneNumber);
            if (numberInfo != null) {
                countryCode = numberInfo.get("countryCode");
            }
            mc.addDestination(compDest, countryCode);
            ++destsCount;
        }
        return destsCount;
    }

    @Override
    public void refreshScheduledDestinationsUpdate(MessageDestinationsList destsList) throws Exception {
        if (destsList == null) {
            throw new Exception("Invalid object reference to message destinations collection.");
        }
        if (!this.isScheduled()) {
            throw new Exception("The message has not been scheduled for refreshing updated destinations.");
        }
        for (MessageDestination mDest : destsList) {
            if (mDest.getStatus() == DestinationStatus.DS_SCHEDULE_DELETED) {
                this.removeDestination(mDest);
                continue;
            }
            this.resetScheduledDestination(mDest.getMessageId());
        }
    }

    private void resetScheduledDestination(String messageId) throws Exception {
        if (messageId == null) {
            throw new Exception("Invalid message identifier for resetting destination mode.");
        }
        if (!this._destIdsMap.containsKey(messageId)) {
            throw new Exception(String.format("Message identifier '%s' does not exist.", messageId));
        }
        ComposerDestination preCompDest = this.getMappedDestinationById(messageId);
        String phoneNumber = preCompDest.getPhoneNumber();
        Object data = preCompDest.getData();
        DestinationMode destMode = DestinationMode.DM_NONE;
        ComposerDestination newCompDest = this.createComposerDestination(phoneNumber, messageId, destMode, data, true);
        String countryCode = this.getDestinationCountryCode(phoneNumber);
        this.removeDestination(preCompDest);
        this.addDestination(newCompDest, countryCode);
    }

    private boolean removeDestination(MessageDestination md) throws Exception {
        ComposerDestination cd;
        if (!this.isScheduled()) {
            throw new Exception("Message destination objects can only be removed from loaded scheduled messages.");
        }
        String messageId = md.getMessageId();
        if (this._destIdsMap.containsKey(messageId) && (cd = this.getMappedDestinationById(messageId)) != null) {
            return this.removeDestination(cd);
        }
        return false;
    }

    @Override
    public boolean removeDestinationById(String messageId) throws Exception {
        if (!this.isScheduled()) {
            return super.removeDestinationById(messageId);
        }
        if (this.messageIdExists(messageId)) {
            ComposerDestination cd = this.getComposerDestinationById(messageId);
            ComposerDestination tempCd = null;
            if (cd.isScheduled()) {
                DestinationMode destMode = DestinationMode.DM_DELETE;
                tempCd = this.createComposerDestination(null, messageId, destMode, null, true);
            }
            this.removeDestination(cd);
            if (tempCd != null) {
                this.addDestination(tempCd);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean updateDestinationById(String messageId, String phoneNumber) throws Exception {
        if (!this.isScheduled()) {
            return super.updateDestinationById(messageId, phoneNumber);
        }
        if (phoneNumber == null || phoneNumber.isEmpty() || !PhoneUtil.isValidPhoneNumber(phoneNumber)) {
            throw new Exception("Invalid phone number for updating message destination.");
        }
        HashMap<String, String> numInfo = this.formatPhoneNumber(phoneNumber, true);
        String fmtdNumber = numInfo.get("number");
        String countryCode = numInfo.get("countryCode");
        if (this.messageIdExists(messageId)) {
            ComposerDestination cd = this.getComposerDestinationById(messageId);
            return this.updateDestination(cd, fmtdNumber);
        }
        DestinationMode destMode = DestinationMode.DM_UPDATE;
        ComposerDestination cd = this.createComposerDestination(fmtdNumber, messageId, destMode, null, true);
        this.addDestination(cd, countryCode);
        return true;
    }

    @Override
    protected HashMap<String, Object> createDestinationMap(String phoneNumber, String messageId, DestinationMode mode, Object data, boolean scheduled) throws Exception {
        if ((messageId == null || messageId.isEmpty()) && this.isScheduled()) {
            messageId = this.generateMessageId();
        }
        return super.createDestinationMap(phoneNumber, messageId, mode, data, scheduled);
    }

    private String generateMessageId() {
        String messageId;
        boolean exists;
        while (exists = this._destIdsMap.containsKey(messageId = UUID.randomUUID().toString())) {
        }
        return messageId;
    }

    @Override
    protected HashMap<String, Object> validateDestinationUpdate(String prePhoneNumber, String newPhoneNumber) throws Exception {
        if (prePhoneNumber == null || prePhoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to previous phone number for updating destination.");
        }
        if (newPhoneNumber == null || prePhoneNumber.isEmpty()) {
            throw new Exception("Invalid reference to new phone number for updating destination.");
        }
        HashMap<String, String> preNumInfo = this.formatPhoneNumber(prePhoneNumber);
        HashMap<String, String> newNumInfo = this.formatPhoneNumber(newPhoneNumber);
        if (preNumInfo == null) {
            throw new Exception("Invalid or unsupported previous phone number for updating destination.");
        }
        if (newNumInfo == null) {
            throw new Exception("Invalid or unsupported new phone number for updating destination.");
        }
        if (!this.isScheduled()) {
            if (!this.formattedDestinationExists(preNumInfo.get("number"))) {
                throw new Exception(String.format("Phone number '%s' does not exist in the destinations list.", prePhoneNumber));
            }
            if (this.formattedDestinationExists(newNumInfo.get("number"))) {
                throw new Exception(String.format("Phone number '%s' alrady exists in the destinations list.", newPhoneNumber));
            }
        }
        HashMap<String, Object> numInfoData = new HashMap<String, Object>();
        numInfoData.put("pre", preNumInfo);
        numInfoData.put("new", newNumInfo);
        return numInfoData;
    }

    @Override
    public void validateDestinationSenderName(String phoneNumber) throws Exception {
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phoneNumber);
        if (numberInfo == null) {
            return;
        }
        String fmtdNumber = numberInfo.get("number");
        if (this._userData == null || !this.formattedDestinationExists(fmtdNumber)) {
            return;
        }
        String countryCode = (String)((HashMap)this._destNumbersMap.get(fmtdNumber)).get(__DEST_COUNTRYCODE_LABEL__);
        HashMap<String, HashMap<String, Object>> routeFilters = this._userData.getRouteFilters();
        if (countryCode != null && !countryCode.isEmpty() && routeFilters.containsKey(countryCode)) {
            boolean numericSenderAllowed;
            String countryName = routeFilters.get(countryCode).get("countryName").toString();
            boolean regSender = (Boolean)routeFilters.get(countryCode).get("registerSender");
            if (regSender) {
                this.checkSenderRegistration(countryCode, countryName);
            }
            if (MessageUtil.isNumericSender(this._sender) && !(numericSenderAllowed = ((Boolean)routeFilters.get(countryCode).get("numericSenderAllowed")).booleanValue())) {
                throw new Exception(String.format("Numeric message sender are not allowed in sending messages to '%s'.", countryName));
            }
        }
    }

    private void checkSenderRegistration(String countryCode, String countryName) throws Exception {
        HashMap<String, Object> senders = this._userData.getMessageSenders();
        String categoryLabel = MessageUtil.getMessageCategoryLabel(this._category);
        boolean senderMatched = false;
        if (senders == null || !senders.containsKey(categoryLabel)) {
            throw new Exception(String.format("Message sender name '%s' is not permitted for sending messages to %s. Please make a request from your account.", this._sender, countryName));
        }
        HashMap sendersList = (HashMap)senders.get(categoryLabel);
        for (String senderName : sendersList.keySet()) {
            boolean caseSensitive = (Boolean)((HashMap)sendersList.get(senderName)).get("sensitive");
            String[] countryCodes = (String[])((HashMap)sendersList.get(senderName)).get("countryCodes");
            if (!this.isMessageSenderMatch(senderName, caseSensitive) || !this.senderCountryCodeExists(countryCodes, countryCode)) continue;
            senderMatched = true;
            break;
        }
        if (!senderMatched) {
            throw new Exception(String.format("Message sender '%s' is not permitted for sending messages to %s.", this._sender, countryName));
        }
    }

    private boolean senderCountryCodeExists(String[] countryCodes, String testCode) {
        for (String code : countryCodes) {
            if (!code.equalsIgnoreCase(testCode)) continue;
            return true;
        }
        return false;
    }

    private boolean isMessageSenderMatch(String testSender, boolean caseSensitive) {
        return caseSensitive ? this._sender.equals(testSender) : this._sender.equalsIgnoreCase(testSender);
    }

    @Override
    public void setScheduleDateTime(Date dateTime) throws Exception {
        this._scheduler.setScheduleDateTime(dateTime);
    }

    @Override
    public void setScheduleDateTime(Date dateTime, String utcOffset) throws Exception {
        this._scheduler.setScheduleDateTime(dateTime, utcOffset);
    }

    @Override
    public void setScheduleDateTime(Date dateTime, String region, String city) throws Exception {
        this._scheduler.setScheduleDateTime(dateTime, region, city);
    }
}

