/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Compose;

import Zenoph.Notify.Utils.MessageUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Schedule {
    private Date _dateTime = null;
    private String _utcOffset = null;

    private void validateScheduling(Date dateTime) throws Exception {
        if (dateTime == null) {
            throw new Exception("Invalid date time object for scheduling message.");
        }
    }

    private String getUTCOffset(String region, String city) throws Exception {
        HashMap<String, List<String[]>> timeZones = MessageUtil.getTimeZones();
        String utcOffset = null;
        boolean found = false;
        if (timeZones == null || timeZones.isEmpty()) {
            throw new Exception("Time zones data has not been loaded.");
        }
        for (Map.Entry<String, List<String[]>> hm : timeZones.entrySet()) {
            String regionName = hm.getKey();
            if (!regionName.equalsIgnoreCase(region)) continue;
            List<String[]> citiesList = hm.getValue();
            for (int i = 0; i < citiesList.size(); ++i) {
                if (!citiesList.get(i)[0].equalsIgnoreCase(city)) continue;
                utcOffset = citiesList.get(i)[1];
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            throw new Exception("Invalid time zone region and city specifiers.");
        }
        return utcOffset;
    }

    void setScheduleDateTime(Date dateTime) throws Exception {
        if (dateTime == null) {
            this._dateTime = null;
            this._utcOffset = null;
            return;
        }
        this.validateScheduling(dateTime);
        this._dateTime = dateTime;
        this._utcOffset = null;
    }

    void setScheduleDateTime(Date dateTime, String utcOffset) throws Exception {
        this.validateScheduling(dateTime);
        if (utcOffset == null || utcOffset.isEmpty()) {
            throw new Exception("Missing or invalid UTC offset for message scheduling.");
        }
        if (!MessageUtil.isValidTimeZoneUTCOffset(utcOffset)) {
            throw new Exception(String.format("The specified time zone offset '%s' is invalid or not in the correct format.", utcOffset));
        }
        this._dateTime = dateTime;
        this._utcOffset = utcOffset;
    }

    void setScheduleDateTime(Date dateTime, String region, String city) throws Exception {
        this.validateScheduling(dateTime);
        if (dateTime == null) {
            throw new Exception("Invalid Date object for message scheduling.");
        }
        if (region == null || region.isEmpty()) {
            throw new Exception("Missing or invalid scheduling time zone region.");
        }
        if (city == null || city.isEmpty()) {
            throw new Exception("Missing or invalid scheduling time zone city.");
        }
        this._utcOffset = this.getUTCOffset(region, city);
    }

    Date getDateTime() {
        return this._dateTime;
    }

    String getUTCOffset() {
        return this._utcOffset;
    }
}

