/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Enums;

import java.util.HashMap;

public enum DestinationStatus {
    DS_UNKNOWN(2101),
    DS_SCHEDULE_CANCELLED(2102),
    DS_SCHEDULE_DELETED(2103),
    DS_SUBMIT_SCHEDULED(2104),
    DS_SUBMIT_ENROUTE(2105),
    DS_SUBMIT_PROCESSING(2106),
    DS_SUBMIT_QUEUED(2107),
    DS_PENDING_DELIV_REPT(2108),
    DS_SUBMITTED(2109),
    DS_DELIVERED(2110),
    DS_EXPIRED(2111),
    DS_UNDELIVERED(2112),
    DS_REJECTED(2113),
    DS_REJECTED_SYSTEM(2114),
    DS_REJECTED_VALUES_EMPTY(2115),
    DS_REJECTED_VALUES_MISVAL(2116),
    DS_REJECTED_VALUES_EXISTS(2117),
    DS_REJECTED_VALUES_COUNT(2118),
    DS_REJECTED_DESTINATION(2119),
    DS_REJECTED_DESTINATION_DUPLICATE(2120),
    DS_REJECTED_INSUFF_CREDIT(2121),
    DS_REJECTED_NETWORK(2122),
    DS_REJECTED_NETWORK_IGNORED(2123),
    DS_REJECTED_MESSAGE(2124),
    DS_REJECTED_MESSAGE_TYPE(2125),
    DS_REJECTED_SENDER(2126),
    DS_REJECTED_SENDER_NUMERIC(2127),
    DS_REJECTED_SENDER_UNREGISTERED(2128),
    DS_REJECTED_OPERATOR(2129),
    DS_REJECTED_OPERATOR_SPAM(2130),
    DS_REJECTED_MSGID_DUPLICATE(2131),
    DS_REJECTED_MSGID_LENGTH(2132),
    DS_REJECTED_MSGID_INVALID(2133),
    DS_REJECTED_UNAV_CONN(2134),
    DS_REJECTED_SCHEDULE(2135),
    DS_REJECTED_WAP_TITLE(2136),
    DS_REJECTED_WAP_URL(2137),
    DS_IGNORED_LOAD_MAX(2138),
    DS_SUBMIT_PENDING_ACK(2139),
    DS_REJECTED_CREDIT_HOLD(2140);

    int _id = 0;
    private static final HashMap<Integer, DestinationStatus> _statusMap;

    private DestinationStatus(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public static DestinationStatus fromInt(int id) throws Exception {
        DestinationStatus ds = _statusMap.get(id);
        if (ds == null) {
            throw new Exception("Invalid destination status identifier.");
        }
        return ds;
    }

    public static boolean isDefined(int id) {
        return _statusMap.get(id) != null;
    }

    static {
        _statusMap = new HashMap();
        for (DestinationStatus ds : DestinationStatus.values()) {
            _statusMap.put(ds.getId(), ds);
        }
    }
}

