/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Enums;

import java.util.HashMap;

public enum MessageCategory {
    SMS(1),
    VOICE(2),
    USSD(3);

    private int _id = 0;
    private static final HashMap<Integer, MessageCategory> _categoryMap;

    private MessageCategory(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public static MessageCategory fromInt(int id) throws Exception {
        MessageCategory mc = _categoryMap.get(id);
        if (mc == null) {
            throw new Exception("Invalid message category identifier.");
        }
        return mc;
    }

    static {
        _categoryMap = new HashMap();
        for (MessageCategory mc : MessageCategory.values()) {
            _categoryMap.put(mc.getId(), mc);
        }
    }
}

