/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Request;

import Zenoph.Notify.Build.Writer.DataWriter;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Request.NotifyRequest;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Response.MessageResponse;
import Zenoph.Notify.Store.AuthProfile;
import java.util.ArrayList;
import java.util.List;

public class DestinationsDeliveryRequest
extends NotifyRequest {
    private List<String> _messageIds;
    private String _batchId;

    public DestinationsDeliveryRequest() {
        this.init();
    }

    public DestinationsDeliveryRequest(AuthProfile p) throws Exception {
        super(p);
        this.init();
    }

    private void init() {
        this._messageIds = new ArrayList<String>();
    }

    private void validate() throws Exception {
        if (this._batchId == null || this._batchId.isEmpty()) {
            throw new Exception("Message template identifier has not been set for destinations delivery request.");
        }
        if (this._messageIds == null || this._messageIds.isEmpty()) {
            throw new Exception("There are no destination identifiers for delivery status request.");
        }
    }

    @Override
    public APIResponse submit() throws Exception {
        this.validate();
        this.setRequestResource("report/message/delivery/destinations/" + this._batchId);
        if (this._messageIds.size() > 5000) {
            this.setResponseContentType(ContentType.GZBIN_XML);
        }
        this.initHttpRequest();
        DataWriter dw = this.createDataWriter();
        dw.writeDestinationsDeliveryRequest(this._messageIds, this._httpConn.getOutputStream());
        APIResponse apiResp = super.submit();
        return MessageResponse.create(apiResp);
    }

    public void addMessageId(String messageId) throws Exception {
        if (messageId == null || messageId.isEmpty()) {
            throw new Exception("Invalid destination identifier for destination delivery request.");
        }
        this._messageIds.add(messageId);
    }

    public void setBatchId(String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new Exception("Invalid message template identifier for destinations delivery request.");
        }
        this._batchId = batchId;
    }
}

