/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Request;

import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Request.NotifyRequest;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Response.MessageResponse;
import Zenoph.Notify.Store.AuthProfile;

public class MessageDeliveryRequest
extends NotifyRequest {
    private String _batchId;

    public MessageDeliveryRequest() {
    }

    public MessageDeliveryRequest(AuthProfile p) throws Exception {
        super(p);
    }

    public void setBatchId(String templateId) throws Exception {
        if (templateId == null || templateId.isEmpty()) {
            throw new Exception("Invalid message identifier for delivery request.");
        }
        this._batchId = templateId;
    }

    @Override
    public APIResponse submit() throws Exception {
        if (this._batchId == null || this._batchId.isEmpty()) {
            throw new Exception("Message identifier has not been set for delivery status request.");
        }
        this.setRequestResource(String.format("report/message/delivery/%s", this._batchId));
        this.setResponseContentType(ContentType.GZBIN_XML);
        this.initHttpRequest();
        APIResponse apiResp = super.submit();
        return MessageResponse.create(apiResp);
    }
}

