/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Request;

import Zenoph.Notify.Build.Writer.DataWriter;
import Zenoph.Notify.Enums.AuthModel;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Enums.HTTPCode;
import Zenoph.Notify.Events.ISubmitCompletedListener;
import Zenoph.Notify.Events.ISubmitProgressListener;
import Zenoph.Notify.Events.SubmitCompletedEvent;
import Zenoph.Notify.Events.SubmitProgressChangedEvent;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Store.AuthProfile;
import Zenoph.Notify.Utils.Base64Util;
import Zenoph.Notify.Utils.RequestUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class NotifyRequest {
    AuthProfile _authProfile;
    AuthModel _authModel;
    String _authLogin;
    String _authPsswd;
    String _authApiKey;
    private static String _urlScheme;
    private static final String TARGET_API_VERSION;
    private static final String AUTH_FACTOR_SEPARATOR;
    private static final int PROGRESS_PERC_SHARE;
    private List _listeners;
    private List _progressListeners;
    protected boolean _loadaps;
    protected boolean _isFileUpload = false;
    protected int _progressPercentage;
    protected static final String DEF_ENCODING;
    private boolean _secureConn = true;
    private int _htpPort;
    private int _httpsPort;
    private String _host = null;
    protected ContentType _contentType;
    private ContentType _acceptType;
    protected HttpURLConnection _httpConn;
    protected String _requestResource;

    public NotifyRequest() {
        this.initDefaults();
    }

    public NotifyRequest(AuthProfile ap) throws Exception {
        this.validateAuthProfile(ap);
        this._authProfile = ap;
        this.initDefaults();
    }

    private void initDefaults() {
        this._loadaps = false;
        this._contentType = ContentType.XML;
        this._acceptType = ContentType.XML;
        this._authModel = AuthModel.API_KEY;
        this._listeners = new ArrayList();
        this._progressListeners = new ArrayList();
        this._progressPercentage = 0;
        this._htpPort = 80;
        this._httpsPort = 443;
    }

    protected final void validateAuthProfile(AuthProfile ap) throws Exception {
        if (ap != null && !ap.authenticated()) {
            throw new Exception("User profile has not been authenticated.");
        }
    }

    public void setAuthProfile(AuthProfile ap) throws Exception {
        this.validateAuthProfile(ap);
        this._authProfile = ap;
    }

    public void setHost(String host) throws Exception {
        if (host == null || host.isEmpty()) {
            throw new Exception("Invalid request host URL.");
        }
        this._host = host;
    }

    public void setHttpPort(int port) throws Exception {
        if (port <= 0) {
            throw new Exception("Invalid http port number.");
        }
        this._htpPort = port;
    }

    public void setHttpsPort(int port) throws Exception {
        if (port <= 0) {
            throw new Exception("Invalid https port number.");
        }
        this._httpsPort = port;
    }

    protected void setRequestResource(String res) throws Exception {
        if (res == null || res.isEmpty()) {
            throw new Exception("Invalid reference to request resource.");
        }
        this._requestResource = res;
    }

    public void setRequestContentType(ContentType type) throws Exception {
        if (!NotifyRequest.requestContentTypeSupported(type)) {
            throw new Exception("Unsupported request content type.");
        }
        this._contentType = type;
    }

    protected void setResponseContentType(ContentType accept) throws Exception {
        if (!NotifyRequest.responseContentTypeSupported(accept)) {
            throw new Exception("Unsupported response content type.");
        }
        this._acceptType = accept;
    }

    public static boolean requestContentTypeSupported(ContentType contentType) {
        switch (contentType) {
            case XML: 
            case GZBIN_XML: 
            case WWW_URL_ENCODED: 
            case GZBIN_WWW_URL_ENCODED: 
            case MULTIPART_FORM_DATA: {
                return true;
            }
        }
        return false;
    }

    public static boolean responseContentTypeSupported(ContentType contentType) {
        switch (contentType) {
            case XML: 
            case GZBIN_XML: {
                return true;
            }
        }
        return false;
    }

    public void useSecureConnection(boolean secure) {
        this._secureConn = secure;
    }

    public void useSecureConnection(boolean secure, int port) throws Exception {
        this.useSecureConnection(secure);
        if (secure) {
            this.setHttpsPort(port);
        } else {
            this.setHttpPort(port);
        }
    }

    private void assertRequestHTTPStatusCode(int code) throws Exception {
        HTTPCode hc = HTTPCode.fromInt(code);
        switch (hc) {
            case OK: {
                return;
            }
            case ERROR_BAD_REQUEST: {
                throw new Exception("Bad request.");
            }
            case ERROR_UNAUTHORIZED: {
                throw new Exception("Unauthorised request.");
            }
            case ERROR_FORBIDDEN: {
                throw new Exception("Forbidden request.");
            }
            case ERROR_NOT_FOUND: {
                throw new Exception("Request resource not found.");
            }
            case ERROR_METHOD_NOT_ALLOWED: {
                throw new Exception("Request method not allowed.");
            }
            case ERROR_NOT_ACCEPTABLE: {
                throw new Exception("Response content type is not acceptable.");
            }
            case ERROR_UNPROCESSABLE: {
                throw new Exception("Request could not be processed.");
            }
            case ERROR_INTERNAL: {
                throw new Exception("Internal server error.");
            }
        }
        throw new Exception(String.format("Unknown request error <%d>.", hc.getId()));
    }

    protected void initHttpRequest() throws Exception {
        String requestURL = this.getRequestURL();
        URL u = new URL(requestURL);
        this._httpConn = (HttpURLConnection)u.openConnection();
        this._httpConn.setUseCaches(false);
        this._httpConn.setDoInput(true);
        this._httpConn.setDoOutput(true);
        this._httpConn.setRequestMethod("POST");
        this._httpConn.setRequestProperty("Content-Type", RequestUtil.getDataContentTypeLabel(this._contentType));
        this._httpConn.setRequestProperty("Accept", RequestUtil.getDataContentTypeLabel(this._acceptType));
        this._httpConn.setRequestProperty("Authorization", this.getAuthData());
    }

    private String generateAuthFactor() throws Exception {
        if (this._authLogin == null || this._authLogin.isEmpty()) {
            throw new Exception("Invalid login for generating auth factor.");
        }
        if (this._authPsswd == null || this._authPsswd.isEmpty()) {
            throw new Exception("Invalid password for generating auth factor.");
        }
        String factor = String.format("%s%s%s", this._authLogin, AUTH_FACTOR_SEPARATOR, this._authPsswd);
        return Base64Util.encodeBytes(factor.getBytes("UTF-8"));
    }

    private String getAuthData() throws Exception {
        String authData;
        if (this._authProfile != null) {
            this.pullAuthInfoFromProfile();
        }
        this.validateAuth();
        switch (this._authModel) {
            case API_KEY: {
                authData = String.format("%s %s", "key", this._authApiKey);
                break;
            }
            case PORTAL_PASS: {
                authData = String.format("%s %s", "factor", this.generateAuthFactor());
                break;
            }
            default: {
                throw new Exception("Unknown request authentication model.");
            }
        }
        return String.format("%s%s", authData, this._loadaps ? " ls" : "");
    }

    private void notifyRequestSubmitProgress(int perc) {
        this.fireRequestSubmitProgressEvent(perc);
    }

    private void notifyRequestSubmitComplete() {
        this.fireRequestSubmitCompletedEvent();
    }

    private synchronized void fireRequestSubmitProgressEvent(int perc) {
        SubmitProgressChangedEvent spe = new SubmitProgressChangedEvent(this, perc);
        Iterator it = this._progressListeners.iterator();
        while (it.hasNext()) {
            ((ISubmitProgressListener)it.next()).submitProgressChanged(spe);
        }
    }

    public synchronized void addSubmitProgressListener(ISubmitProgressListener spl) throws Exception {
        if (spl == null) {
            throw new Exception("Invalid event listener for request submission progress.");
        }
        this._progressListeners.add(spl);
    }

    public synchronized void removeSubmitProgressListener(ISubmitProgressListener spl) {
        this._progressListeners.remove(spl);
    }

    private synchronized void fireRequestSubmitCompletedEvent() {
        SubmitCompletedEvent sce = new SubmitCompletedEvent(this);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            ((ISubmitCompletedListener)it.next()).submitCompleted(sce);
        }
    }

    public synchronized void addSubmitCompletedListener(ISubmitCompletedListener scl) throws Exception {
        if (scl == null) {
            throw new Exception("Invalid event listener for request completion.");
        }
        this._listeners.add(scl);
    }

    public synchronized void removeSubmitCompletedListener(ISubmitCompletedListener scl) {
        this._listeners.remove(scl);
    }

    private void pullAuthInfoFromProfile() throws Exception {
        this._authModel = this._authProfile.getAuthModel();
        this._authLogin = this._authProfile.getAuthLogin();
        this._authPsswd = this._authProfile.getAuthPassword();
        this._authApiKey = this._authProfile.getAuthApiKey();
    }

    private void validateAuth() throws Exception {
        if (this._authModel == AuthModel.PORTAL_PASS) {
            if (this._authLogin == null || this._authLogin.isEmpty() || this._authPsswd == null || this._authPsswd.isEmpty()) {
                throw new Exception("Missing account login and or password for authentication.");
            }
        } else if (this._authModel == AuthModel.API_KEY && (this._authApiKey == null || this._authApiKey.isEmpty())) {
            throw new Exception("Missing or invalid API key for authentication.");
        }
    }

    protected String getRequestURL() throws Exception {
        if (this._requestResource == null || this._requestResource.isEmpty()) {
            throw new Exception("Invalid reference to request resource.");
        }
        String urlScheme = _urlScheme + (this._secureConn ? "s" : "");
        int connPort = this._secureConn ? this._httpsPort : this._htpPort;
        return String.format("%s://%s:%d/v%s/%s", urlScheme, this._host, connPort, TARGET_API_VERSION, this._requestResource);
    }

    protected void updateRequestSubmitProgress() {
        if (this._progressPercentage < 0 || this._progressPercentage > 100) {
            this._progressPercentage = 0;
        }
        int adjustedProgress = this._progressPercentage * (100 - PROGRESS_PERC_SHARE) / 100;
        this.notifyRequestSubmitProgress(adjustedProgress);
    }

    protected DataWriter createDataWriter() throws Exception {
        return DataWriter.create(this._contentType);
    }

    public APIResponse submit() throws Exception {
        String inputLine;
        if (this._httpConn == null) {
            throw new Exception("HTTP connection has not been initialised.");
        }
        if (this._progressPercentage > 100 - PROGRESS_PERC_SHARE) {
            this._progressPercentage = 100 - PROGRESS_PERC_SHARE;
        }
        int remPercentage = 100 - this._progressPercentage;
        this._progressPercentage += 20 * remPercentage / 100;
        this.notifyRequestSubmitProgress(this._progressPercentage);
        this._progressPercentage += 60 * remPercentage / 100;
        this.notifyRequestSubmitProgress(this._progressPercentage);
        int httpCode = this._httpConn.getResponseCode();
        this._progressPercentage = 100;
        this.notifyRequestSubmitProgress(this._progressPercentage);
        this.notifyRequestSubmitComplete();
        this.assertRequestHTTPStatusCode(httpCode);
        String responseContentType = this._httpConn.getContentType();
        BufferedReader br = new BufferedReader(new InputStreamReader(this._httpConn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = br.readLine()) != null) {
            response.append(inputLine);
        }
        br.close();
        Object[] retArr = new Object[]{httpCode, responseContentType, response.toString()};
        return APIResponse.create(retArr);
    }

    public void setAuthModel(AuthModel model) {
        this._authModel = model;
    }

    public void setAuthLogin(String login) throws Exception {
        if (login == null || login.isEmpty()) {
            throw new Exception("Missing or invalid account login.");
        }
        if (this._authModel != AuthModel.PORTAL_PASS) {
            throw new Exception("Invalid call for setting account login.");
        }
        this._authLogin = login;
    }

    public void setAuthPassword(String psswd) throws Exception {
        if (psswd == null || psswd.isEmpty()) {
            throw new Exception("Missing or invalid account password.");
        }
        if (this._authModel != AuthModel.PORTAL_PASS) {
            throw new Exception("Invalid call for setting account password.");
        }
        this._authPsswd = psswd;
    }

    public void setAuthApiKey(String mKey) {
        this._authApiKey = mKey;
    }

    static {
        PROGRESS_PERC_SHARE = 50;
        AUTH_FACTOR_SEPARATOR = "__::";
        TARGET_API_VERSION = "5";
        DEF_ENCODING = "UTF-8";
        _urlScheme = "http";
    }
}

