/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Request;

import Zenoph.Notify.Build.Writer.DataWriter;
import Zenoph.Notify.Collections.PersonalisedValuesList;
import Zenoph.Notify.Compose.ISMSComposer;
import Zenoph.Notify.Compose.SMSComposer;
import Zenoph.Notify.Enums.AuthModel;
import Zenoph.Notify.Enums.DestinationMode;
import Zenoph.Notify.Enums.NumberAddInfo;
import Zenoph.Notify.Enums.SMSType;
import Zenoph.Notify.Events.ISubmitCompletedListener;
import Zenoph.Notify.Events.ISubmitProgressListener;
import Zenoph.Notify.Request.MessageRequest;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Response.MessageResponse;
import Zenoph.Notify.Store.AuthProfile;
import Zenoph.Notify.Store.PersonalisedValues;
import Zenoph.Notify.Utils.MessageUtil;
import java.util.HashMap;
import java.util.List;

public class SMSRequest
extends MessageRequest
implements ISMSComposer {
    protected static List<HashMap<String, Object>> _messageTypes = null;
    private static String BASE_RESOURCE = "message/sms/send";

    public SMSRequest() throws Exception {
        this._composer = new SMSComposer();
    }

    public SMSRequest(AuthProfile ap) throws Exception {
        super(ap);
        this._composer = new SMSComposer(ap);
    }

    @Override
    public List<String> loadTemplates() throws Exception {
        return null;
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        String sender = ((SMSComposer)this._composer).getSender();
        SMSType type = ((SMSComposer)this._composer).getSMSType();
        if (sender == null || sender.isEmpty()) {
            throw new Exception("Message sender has not been set.");
        }
    }

    @Override
    public APIResponse submit() throws Exception {
        this._progressPercentage = 0;
        this.validate();
        this.setRequestResource(BASE_RESOURCE);
        this._progressPercentage += 30;
        this.updateRequestSubmitProgress();
        this.initHttpRequest();
        DataWriter dw = this.createDataWriter();
        dw.writeSMSRequest((SMSComposer)this._composer, this._httpConn.getOutputStream());
        this._progressPercentage += 50;
        this.updateRequestSubmitProgress();
        this._progressPercentage = 100;
        this.updateRequestSubmitProgress();
        APIResponse apiResp = super.submit();
        return MessageResponse.create(apiResp);
    }

    static String getBaseResource() throws Exception {
        return BASE_RESOURCE;
    }

    public static APIResponse submitComposer(SMSComposer tmc, AuthProfile ap) throws Exception {
        return SMSRequest.submitComposer(tmc, ap, null, null);
    }

    public static APIResponse submitComposer(SMSComposer tmc, AuthProfile ap, ISubmitProgressListener spl, ISubmitCompletedListener scl) throws Exception {
        if (ap == null) {
            throw new Exception("Invalid reference to authentication profile for request.");
        }
        if (!ap.authenticated()) {
            throw new Exception("Authentication profile has not been validated for request.");
        }
        if (ap.getAuthModel() == AuthModel.API_KEY) {
            return SMSRequest.submitComposer(tmc, ap.getAuthApiKey(), spl, scl);
        }
        return SMSRequest.submitComposer(tmc, ap.getAuthLogin(), ap.getAuthPassword(), spl, scl);
    }

    public static APIResponse submitComposer(SMSComposer tmc, String apiKey) throws Exception {
        return SMSRequest.submitComposer(tmc, apiKey, null, null);
    }

    public static APIResponse submitComposer(SMSComposer tmc, String apiKey, ISubmitProgressListener spl, ISubmitCompletedListener scl) throws Exception {
        if (tmc == null) {
            throw new Exception("Invalid reference to message object for request.");
        }
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("Invalid API key for request.");
        }
        SMSRequest tmr = new SMSRequest();
        tmr.setAuthModel(AuthModel.API_KEY);
        tmr.setAuthApiKey(apiKey);
        tmr._composer = tmc;
        if (spl != null && scl != null) {
            tmr.addSubmitProgressListener(spl);
            tmr.addSubmitCompletedListener(scl);
        }
        APIResponse apiResp = tmr.submit();
        if (spl != null && scl != null) {
            tmr.removeSubmitProgressListener(spl);
            tmr.removeSubmitCompletedListener(scl);
        }
        return apiResp;
    }

    public static APIResponse submitComposer(SMSComposer tmc, String plogin, String ppass) throws Exception {
        return SMSRequest.submitComposer(tmc, plogin, ppass, null, null);
    }

    public static APIResponse submitComposer(SMSComposer tmc, String plogin, String ppass, ISubmitProgressListener spl, ISubmitCompletedListener scl) throws Exception {
        if (tmc == null) {
            throw new Exception("Invalid reference to message object for request.");
        }
        if (plogin == null || plogin.isEmpty()) {
            throw new Exception("Invalid account login for request.");
        }
        if (ppass == null || ppass.isEmpty()) {
            throw new Exception("Invalid account password for request.");
        }
        SMSRequest tmr = new SMSRequest();
        tmr.setAuthModel(AuthModel.PORTAL_PASS);
        tmr.setAuthLogin(plogin);
        tmr.setAuthPassword(ppass);
        tmr._composer = tmc;
        if (spl != null && scl != null) {
            tmr.addSubmitProgressListener(spl);
            tmr.addSubmitCompletedListener(scl);
        }
        APIResponse apiResp = tmr.submit();
        if (spl != null && scl != null) {
            tmr.removeSubmitProgressListener(spl);
            tmr.removeSubmitCompletedListener(scl);
        }
        return apiResp;
    }

    @Override
    public SMSType getDefaultSMSType() throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getDefaultSMSType();
    }

    public static SMSType messageTypeToEnum(String type) throws Exception {
        return MessageUtil.messageTypeToEnum(type);
    }

    public static String messageTypeToStr(SMSType type) throws Exception {
        return MessageUtil.messageTypeToStr(type);
    }

    public static List<SMSType> getSMSTypes() throws Exception {
        return SMSComposer.getSMSTypes();
    }

    @Override
    public SMSType getSMSType() throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getSMSType();
    }

    @Override
    public void setSMSType(String type) throws Exception {
        this.assertComposer();
        ((SMSComposer)this._composer).setSMSType(type);
    }

    @Override
    public void setSMSType(SMSType type) throws Exception {
        this.assertComposer();
        ((SMSComposer)this._composer).setSMSType(type);
    }

    @Override
    public String[] getRegisteredSenderIds() throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getRegisteredSenderIds();
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.addDestination(phoneNumber);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx) throws Exception {
        this.assertComposer();
        return this._composer.addDestination(phoneNumber, throwEx);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return this.addDestination(phoneNumber, true, values);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, String[] values, String messageId) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).addDestination(phoneNumber, values, messageId);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).addDestination(phoneNumber, throwEx, values);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx, String[] values, String messageId) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).addDestination(phoneNumber, throwEx, values, messageId);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).addPersonalisedDestination(phoneNumber, values);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, String[] values, String messageId) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).addPersonalisedDestination(phoneNumber, values, messageId);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, boolean throwEx, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).addPersonalisedDestination(phoneNumber, throwEx, values);
    }

    @Override
    public NumberAddInfo addPersonalisedDestination(String phoneNumber, boolean throwEx, String[] values, String messageId) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).addPersonalisedDestination(phoneNumber, throwEx, values, messageId);
    }

    @Override
    public void setMessage(String message) throws Exception {
        this.assertComposer();
        ((SMSComposer)this._composer).setMessage(message);
    }

    @Override
    public void setMessage(String message, boolean isPsnd) throws Exception {
        this.assertComposer();
        ((SMSComposer)this._composer).setMessage(message, isPsnd);
    }

    @Override
    public boolean personalise() throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).personalise();
    }

    @Override
    public DestinationMode getDestinationWriteMode(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getDestinationWriteMode(phoneNumber, values);
    }

    @Override
    public DestinationMode getPersonalisedDestinationWriteMode(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getPersonalisedDestinationWriteMode(phoneNumber, values);
    }

    @Override
    public int getMessageCount() throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getMessageCount();
    }

    public static int getMessageCount(String message, SMSType type) throws Exception {
        return SMSComposer.getMessageCount(message, type);
    }

    @Override
    public String[] getMessageVariables() throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getMessageVariables();
    }

    @Override
    public String[] getMessageVariables(boolean trim) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getMessageVariables(trim);
    }

    public static String[] getMessageVariables(String message) throws Exception {
        return SMSComposer.getMessageVariables(message);
    }

    public static String[] getMessageVariables(String message, boolean trim) throws Exception {
        return SMSComposer.getMessageVariables(message, trim);
    }

    public static int getMessageVariablesCount(String text) throws Exception {
        return SMSRequest.getMessageVariablesCount(text);
    }

    @Override
    public int getMessageVariablesCount() throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getMessageVariablesCount();
    }

    @Override
    public String getMessageId(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getMessageId(phoneNumber, values);
    }

    @Override
    public String[] getPersonalisedMessagePreview(String phoneNumber) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getPersonalisedMessagePreview(phoneNumber);
    }

    @Override
    public String getPersonalisedMessagePreview(String phoneNumber, PersonalisedValues pv) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getPersonalisedMessagePreview(phoneNumber, pv);
    }

    @Override
    public String getPersonalisedMessagePreview(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getPersonalisedMessagePreview(phoneNumber, values);
    }

    @Override
    public String getPersonalisedDestinationMessageId(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getPersonalisedDestinationMessageId(phoneNumber, values);
    }

    @Override
    public PersonalisedValuesList getPersonalisedValues(String phoneNumber) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getPersonalisedValues(phoneNumber);
    }

    @Override
    public String[] getPersonalisedValuesById(String messageId) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).getPersonalisedValuesById(messageId);
    }

    @Override
    public boolean updatePersonalisedValuesById(String messageId, String[] newValues) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).updatePersonalisedValuesById(messageId, newValues);
    }

    @Override
    public boolean updatePersonalisedValues(String phoneNumber, String[] newValues) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).updatePersonalisedValues(phoneNumber, newValues);
    }

    @Override
    public boolean updatePersonalisedValues(String phoneNumber, String[] newValues, String[] prevValues) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).updatePersonalisedValues(phoneNumber, newValues, prevValues);
    }

    @Override
    public boolean updatePersonalisedValues(String phoneNumber, String[] newValues, String messageId) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).updatePersonalisedValues(phoneNumber, newValues, messageId);
    }

    @Override
    public boolean removePersonalisedValues(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).removePersonalisedValues(phoneNumber, values);
    }

    @Override
    public boolean removePersonalisedDestination(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).removePersonalisedDestination(phoneNumber, values);
    }

    @Override
    public boolean removeDestination(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).removeDestination(phoneNumber, values);
    }

    @Override
    public boolean personalisedValuesExists(String phoneNumber, String[] values) throws Exception {
        this.assertComposer();
        return ((SMSComposer)this._composer).personalisedValuesExists(phoneNumber, values);
    }
}

