/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Request;

import Zenoph.Notify.Build.Writer.DataWriter;
import Zenoph.Notify.Build.Writer.MultiPartDataWriter;
import Zenoph.Notify.Compose.IVoiceComposer;
import Zenoph.Notify.Compose.VoiceComposer;
import Zenoph.Notify.Enums.AuthModel;
import Zenoph.Notify.Enums.ContentType;
import Zenoph.Notify.Events.ISubmitCompletedListener;
import Zenoph.Notify.Events.ISubmitProgressListener;
import Zenoph.Notify.Request.MessageRequest;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Response.MessageResponse;
import Zenoph.Notify.Store.AuthProfile;
import java.util.List;

public class VoiceRequest
extends MessageRequest
implements IVoiceComposer {
    private static final String _baseResource = "message/voice/send";

    public VoiceRequest() {
        this._composer = new VoiceComposer();
    }

    public VoiceRequest(AuthProfile ap) throws Exception {
        super(ap);
        this._composer = new VoiceComposer(ap);
    }

    @Override
    public APIResponse submit() throws Exception {
        this.validate();
        this.setRequestResource(_baseResource);
        if (((VoiceComposer)this._composer).isOfflineVoice()) {
            this.setRequestContentType(ContentType.MULTIPART_FORM_DATA);
        }
        this.initHttpRequest();
        DataWriter dw = DataWriter.create(this._contentType);
        dw.writeVoiceRequest((VoiceComposer)this._composer, this._httpConn.getOutputStream());
        if (this._contentType.equals((Object)ContentType.MULTIPART_FORM_DATA)) {
            String boundary = ((MultiPartDataWriter)dw).getDataBoundary();
            this._httpConn.setRequestProperty("Content-Type", String.format("%s; %s", new Object[]{ContentType.MULTIPART_FORM_DATA, boundary}));
        }
        APIResponse apiResp = super.submit();
        return MessageResponse.create(apiResp);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
    }

    public static APIResponse submitComposer(VoiceComposer vm, AuthProfile ap) throws Exception {
        return VoiceRequest.submitComposer(vm, ap, null, null);
    }

    public static APIResponse submitComposer(VoiceComposer vm, AuthProfile ap, ISubmitProgressListener spl, ISubmitCompletedListener scl) throws Exception {
        if (ap == null) {
            throw new Exception("Invalid reference to authentication profile for request.");
        }
        if (!ap.authenticated()) {
            throw new Exception("Authentication profile has not been validated for request.");
        }
        if (ap.getAuthModel() == AuthModel.API_KEY) {
            return VoiceRequest.submitComposer(vm, ap.getAuthApiKey(), spl, scl);
        }
        return VoiceRequest.submitComposer(vm, ap.getAuthLogin(), ap.getAuthPassword(), spl, scl);
    }

    public static APIResponse submitComposer(VoiceComposer vm, String apiKey) throws Exception {
        return VoiceRequest.submitComposer(vm, apiKey, null, null);
    }

    public static APIResponse submitComposer(VoiceComposer vc, String apiKey, ISubmitProgressListener spl, ISubmitCompletedListener scl) throws Exception {
        if (vc == null) {
            throw new Exception("Invalid reference to message object for request.");
        }
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("Invalid API key for request.");
        }
        VoiceRequest vr = new VoiceRequest();
        vr.setAuthModel(AuthModel.API_KEY);
        vr.setAuthApiKey(apiKey);
        vr._composer = vc;
        return vr.submit(spl, scl);
    }

    public static APIResponse submitComposer(VoiceComposer vm, String plogin, String ppass) throws Exception {
        return VoiceRequest.submitComposer(vm, plogin, ppass, null, null);
    }

    public static APIResponse submitComposer(VoiceComposer vm, String plogin, String ppass, ISubmitProgressListener spl, ISubmitCompletedListener scl) throws Exception {
        if (vm == null) {
            throw new Exception("Invalid reference to message object for request.");
        }
        if (plogin == null || plogin.isEmpty()) {
            throw new Exception("Invalid account login for request.");
        }
        if (ppass == null || ppass.isEmpty()) {
            throw new Exception("Invalid account password for request.");
        }
        VoiceRequest vr = new VoiceRequest();
        vr.setAuthModel(AuthModel.PORTAL_PASS);
        vr.setAuthLogin(plogin);
        vr.setAuthPassword(ppass);
        vr._composer = vm;
        return vr.submit(spl, scl);
    }

    @Override
    public List<String> loadTemplates() throws Exception {
        return null;
    }

    @Override
    public void setTemplateReference(String ref) throws Exception {
        this.assertComposer();
        ((VoiceComposer)this._composer).setTemplateReference(ref);
    }

    @Override
    public void setOfflineVoice(String fileName) throws Exception {
        this.assertComposer();
        ((VoiceComposer)this._composer).setOfflineVoice(fileName);
    }

    @Override
    public void setOfflineVoice(String fileName, String tplRef) throws Exception {
        this.assertComposer();
        ((VoiceComposer)this._composer).setOfflineVoice(fileName, tplRef);
    }

    @Override
    public String getTemplateReference() throws Exception {
        this.assertComposer();
        return ((VoiceComposer)this._composer).getTemplateReference();
    }

    @Override
    public String getOfflineVoice() throws Exception {
        this.assertComposer();
        return ((VoiceComposer)this._composer).getOfflineVoice();
    }

    @Override
    public boolean isOfflineVoice() throws Exception {
        this.assertComposer();
        return ((VoiceComposer)this._composer).isOfflineVoice();
    }
}

