/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Store;

import Zenoph.Notify.Enums.DestinationStatus;
import Zenoph.Notify.Utils.RequestUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class MessageDestination {
    private String _destination;
    private String _country;
    private String _messageId;
    private String _message;
    private DestinationStatus _status;
    private Date _submitDateTime;
    private Date _reportDateTime;
    private int _messageCount = 0;
    private int _statusId;
    private Object _data;

    private MessageDestination() {
    }

    public static MessageDestination create(HashMap<String, Object> p) throws Exception {
        if (p == null) {
            throw new Exception("Invalid reference for creating message destination data.");
        }
        MessageDestination destInfo = new MessageDestination();
        if (p.containsKey("phoneNumber")) {
            destInfo._destination = p.get("phoneNumber").toString();
        }
        if (p.containsKey("country")) {
            destInfo._country = p.get("country").toString();
        }
        if (p.containsKey("messageId")) {
            destInfo._messageId = p.get("messageId").toString();
        }
        if (p.containsKey("message")) {
            destInfo._message = p.get("message").toString();
        }
        if (p.containsKey("statusId")) {
            destInfo._statusId = Integer.parseInt(p.get("statusId").toString());
            MessageDestination.setDestinationStatus(destInfo);
        }
        if (p.containsKey("messageCount")) {
            destInfo._messageCount = Integer.parseInt(p.get("messageCount").toString());
        }
        if (p.containsKey("psndValues")) {
            destInfo._data = p.get("psndValues");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(RequestUtil.DATE_TIME_FORMAT);
        if (p.containsKey("submitDateTime")) {
            destInfo._submitDateTime = sdf.parse(p.get("submitDateTime").toString());
        }
        if (p.containsKey("reportDateTime")) {
            destInfo._reportDateTime = sdf.parse(p.get("reportDateTime").toString());
        }
        return destInfo;
    }

    private static void setDestinationStatus(MessageDestination destInfo) throws Exception {
        destInfo._status = DestinationStatus.isDefined(destInfo._statusId) ? DestinationStatus.fromInt(destInfo._statusId) : DestinationStatus.DS_UNKNOWN;
    }

    public int getMessageCount() {
        return this._messageCount;
    }

    public String getPhoneNumber() {
        return this._destination;
    }

    public String getCountry() {
        return this._country;
    }

    public String getMessageId() {
        return this._messageId;
    }

    public String getMessage() {
        return this._message;
    }

    public DestinationStatus getStatus() {
        return this._status;
    }

    public int getStatusId() {
        return this._statusId;
    }

    public Date getSubmitDateTime() {
        return this._submitDateTime;
    }

    public Date getReportDateTime() {
        return this._reportDateTime;
    }

    public Object getData() {
        return this._data;
    }
}

