/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Store;

import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Enums.SMSType;
import Zenoph.Notify.Utils.MessageUtil;
import Zenoph.Notify.Utils.PhoneUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class UserData {
    private SMSType _textMsgType = SMSType.GSM_DEFAULT;
    private HashMap<String, HashMap<String, Object>> _routeFilters;
    private HashMap<String, Object> _messageSenders;
    private HashMap<String, Object> _defaultRoute;
    private String _timeZone;
    private String _defDialCode;

    private UserData() {
    }

    public static UserData create(Document xmlDoc) throws Exception {
        UserData ud = new UserData();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.compile("data/settings/user/timeZone").evaluate(xmlDoc, XPathConstants.NODE);
        ud._timeZone = node.getTextContent();
        node = (Node)xpath.compile("data/settings/user/messageType").evaluate(xmlDoc, XPathConstants.NODE);
        ud._textMsgType = SMSType.fromInt(Integer.parseInt(node.getTextContent()));
        ud._defaultRoute = UserData.extractDefaultRouteInfo(xmlDoc);
        ud._routeFilters = UserData.extractRouteFilters(xmlDoc);
        ud._messageSenders = UserData.extractMessageSenders(xmlDoc);
        return ud;
    }

    private static HashMap<String, Object> extractMessageSenders(Document xmlDoc) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node baseNode = (Node)xpath.compile("data/settings/user/messageSenders").evaluate(xmlDoc, XPathConstants.NODE);
        if (baseNode == null) {
            return null;
        }
        HashMap<String, Object> messageSenders = new HashMap<String, Object>();
        String smsLabel = MessageUtil.getMessageCategoryLabel(MessageCategory.SMS);
        String voiceLabel = MessageUtil.getMessageCategoryLabel(MessageCategory.VOICE);
        if (xpath.compile(smsLabel).evaluate(baseNode, XPathConstants.NODE) != null) {
            messageSenders.put(smsLabel, UserData.pullSenders(baseNode, smsLabel));
        }
        if (xpath.compile(voiceLabel).evaluate(baseNode, XPathConstants.NODE) != null) {
            messageSenders.put(voiceLabel, UserData.pullSenders(baseNode, voiceLabel));
        }
        messageSenders.put("countries", UserData.pullSenderCountries(baseNode, xpath));
        return messageSenders;
    }

    private static HashMap<String, String> pullSenderCountries(Node baseNode, XPath xpath) throws Exception {
        NodeList ctrysNodes = (NodeList)xpath.compile("countries/country").evaluate(baseNode, XPathConstants.NODESET);
        if (ctrysNodes == null) {
            return null;
        }
        HashMap<String, String> countries = new HashMap<String, String>();
        for (int i = 0; i < ctrysNodes.getLength(); ++i) {
            Node n = (Node)xpath.compile("name").evaluate(ctrysNodes.item(i), XPathConstants.NODE);
            String countryName = n.getTextContent();
            n = (Node)xpath.compile("code").evaluate(ctrysNodes.item(i), XPathConstants.NODE);
            String countryCode = n.getTextContent();
            countries.put(countryCode, countryName);
        }
        return countries;
    }

    private static Object pullSenders(Node node, String catLabel) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList selNodes = (NodeList)xpath.compile(String.format("%s/sender", catLabel)).evaluate(node, XPathConstants.NODESET);
        HashMap sendersList = new HashMap();
        if (selNodes != null) {
            for (int i = 0; i < selNodes.getLength(); ++i) {
                Node n = (Node)xpath.compile("name").evaluate(selNodes.item(i), XPathConstants.NODE);
                String senderName = n.getTextContent();
                n = (Node)xpath.compile("caseSensitive").evaluate(selNodes.item(i), XPathConstants.NODE);
                boolean sensitive = n.getTextContent().equalsIgnoreCase("true");
                NodeList ctryCodesNodes = (NodeList)xpath.compile("countryCodes/code").evaluate(selNodes.item(i), XPathConstants.NODESET);
                if (ctryCodesNodes == null || ctryCodesNodes.getLength() == 0) continue;
                String[] senderCtryCodes = new String[ctryCodesNodes.getLength()];
                for (int j = 0; j < ctryCodesNodes.getLength(); ++j) {
                    senderCtryCodes[j] = ctryCodesNodes.item(j).getTextContent();
                }
                HashMap<String, Object> sender = new HashMap<String, Object>();
                sender.put("sensitive", sensitive);
                sender.put("countryCodes", senderCtryCodes);
                sendersList.put(senderName, sender);
            }
        }
        return sendersList;
    }

    private static HashMap<String, Object> extractDefaultRouteInfo(Document xmlDoc) throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node baseNode = (Node)xpath.compile("data/settings/user/defDestination").evaluate(xmlDoc, XPathConstants.NODE);
        Node node = (Node)xpath.compile("countryName").evaluate(baseNode, XPathConstants.NODE);
        hm.put("countryName", node.getTextContent());
        node = (Node)xpath.compile("countryCode").evaluate(baseNode, XPathConstants.NODE);
        hm.put("countryCode", node.getTextContent());
        node = (Node)xpath.compile("dialCode").evaluate(baseNode, XPathConstants.NODE);
        hm.put("dialCode", node.getTextContent());
        node = (Node)xpath.compile("minNumLen").evaluate(baseNode, XPathConstants.NODE);
        hm.put("minNumLen", node.getTextContent());
        node = (Node)xpath.compile("maxNumLen").evaluate(baseNode, XPathConstants.NODE);
        hm.put("maxNumLen", node.getTextContent());
        return hm;
    }

    private static HashMap<String, HashMap<String, Object>> extractRouteFilters(Document xmlDoc) throws Exception {
        HashMap<String, HashMap<String, Object>> hm = new HashMap<String, HashMap<String, Object>>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        String baseNodeName = "data/settings/user/routeFilters";
        NodeList nodes = (NodeList)xpath.compile(String.format("%s/%s", baseNodeName, "filter")).evaluate(xmlDoc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = (Node)xpath.compile(String.format("%s", "countryCode")).evaluate(nodes.item(i), XPathConstants.NODE);
            String countryCode = n.getTextContent();
            HashMap<String, Object> h = new HashMap<String, Object>();
            n = (Node)xpath.compile(String.format("%s", "networksFilter")).evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("networksFilter", n == null || n.getTextContent().equalsIgnoreCase("null") ? null : n.getTextContent());
            n = (Node)xpath.compile("areaCodesFilter").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("areaCodesFilter", n == null || n.getTextContent().equalsIgnoreCase("null") ? null : n.getTextContent());
            n = (Node)xpath.compile("countryName").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("countryName", n.getTextContent());
            n = (Node)xpath.compile("usesAreaCodes").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("usesAreaCodes", n.getTextContent().equalsIgnoreCase("true"));
            n = (Node)xpath.compile("dialCode").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("dialCode", n.getTextContent());
            n = (Node)xpath.compile("cnum_minlen").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("cnum_minlen", n.getTextContent());
            n = (Node)xpath.compile("cnum_maxlen").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("cnum_maxlen", n.getTextContent());
            n = (Node)xpath.compile("registerSender").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("registerSender", n.getTextContent().equalsIgnoreCase("true"));
            n = (Node)xpath.compile("numericSenderAllowed").evaluate(nodes.item(i), XPathConstants.NODE);
            h.put("numericSenderAllowed", n.getTextContent().equalsIgnoreCase("true"));
            hm.put(countryCode, h);
        }
        return hm;
    }

    public static HashMap<String, String> createDestinationCountryMap(String phoneNumber, String countryCode) {
        HashMap<String, String> numberInfo = new HashMap<String, String>();
        numberInfo.put("number", phoneNumber);
        numberInfo.put("countryCode", countryCode);
        return numberInfo;
    }

    private boolean hasCountryDialCode(String dialCode) {
        for (Map.Entry<String, HashMap<String, Object>> kvp : this._routeFilters.entrySet()) {
            if (!kvp.getValue().get("dialCode").toString().equals(dialCode)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultDialCode(String dialCode) throws Exception {
        if (dialCode == null || dialCode.isEmpty()) {
            throw new Exception("Invalid value for setting default dial code.");
        }
        String cleanedCode = dialCode.replaceAll("(\\+)|(00)", "");
        if (cleanedCode == null || cleanedCode.isEmpty()) {
            throw new Exception(String.format("Invalid value '%s' for setting default dial code.", dialCode));
        }
        int code = 0;
        try {
            code = Integer.parseInt(cleanedCode);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Invalid value for default dial code: " + ex.getMessage());
        }
        if (!this.hasCountryDialCode(dialCode)) {
            throw new Exception("Country dial code '%s' is not applicable to user routes.");
        }
        this._defDialCode = Integer.toString(code);
    }

    public String getDefaultDialCode() {
        if (this._defDialCode == null || this._defDialCode.isEmpty()) {
            HashMap<String, Object> defRoute = this._defaultRoute;
            this.setDefaultDialCodeCopy(defRoute);
        }
        return this._defDialCode;
    }

    private void setDefaultDialCodeCopy(HashMap<String, Object> defRoute) {
        this._defDialCode = defRoute.get("dialCode").toString();
    }

    public boolean isRoutesPhoneNumber(String phonenum) throws Exception {
        HashMap<String, String> numberInfo = this.formatPhoneNumber(phonenum);
        return numberInfo != null;
    }

    public HashMap<String, String> formatPhoneNumber(String phoneNumber) throws Exception {
        return this.formatPhoneNumber(phoneNumber, false);
    }

    public HashMap<String, String> formatPhoneNumber(String phoneNumber, boolean throwEx) throws Exception {
        HashMap<String, Object> defRoute;
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            if (!throwEx) {
                return null;
            }
            throw new Exception("Invalid phone number for formatting.");
        }
        String fmtdNumber = PhoneUtil.stripPhoneNumberPrefixes(phoneNumber);
        if (this.isNationalPhoneNumber(fmtdNumber, defRoute = this._defaultRoute)) {
            if (this._defDialCode == null || this._defDialCode.isEmpty()) {
                this.setDefaultDialCodeCopy(defRoute);
            }
            fmtdNumber = String.format("%s%s", this._defDialCode, fmtdNumber);
        }
        HashMap<String, HashMap<String, Object>> filters = this._routeFilters;
        for (Map.Entry<String, HashMap<String, Object>> kvp : filters.entrySet()) {
            String filterStr;
            Matcher m;
            String countryCode = kvp.getKey();
            int cNumMinLen = Integer.parseInt(kvp.getValue().get("cnum_minlen").toString());
            int cNumMaxLen = Integer.parseInt(kvp.getValue().get("cnum_maxlen").toString());
            String pattern = (String)kvp.getValue().get("networksFilter");
            String dialCode = kvp.getValue().get("dialCode").toString();
            String countryWidePattern = String.format("^%s[0-9]{%d,%d}$", dialCode, cNumMinLen, cNumMaxLen);
            if (pattern != null && (m = Pattern.compile(filterStr = String.format("(?:%s%s)", dialCode, pattern)).matcher(fmtdNumber)).find()) {
                return UserData.createDestinationCountryMap(m.group(), countryCode);
            }
            if (((Boolean)kvp.getValue().get("usesAreaCodes")).booleanValue() && (m = Pattern.compile(filterStr = String.format("(?:%s%s)", dialCode, pattern = (String)kvp.getValue().get("areaCodesFilter"))).matcher(fmtdNumber)).find()) {
                return UserData.createDestinationCountryMap(m.group(), countryCode);
            }
            if (!MessageUtil.isRegexMatch(countryWidePattern, fmtdNumber)) continue;
            return UserData.createDestinationCountryMap(fmtdNumber, countryCode);
        }
        if (!throwEx) {
            return null;
        }
        throw new Exception(String.format("Phone number '%s' is not permitted on routes.", phoneNumber));
    }

    private boolean isNationalPhoneNumber(String phonenum, HashMap<String, Object> defRoute) {
        int len = phonenum.length();
        int minLen = Integer.parseInt((String)defRoute.get("minNumLen"));
        int maxLen = Integer.parseInt((String)defRoute.get("maxNumLen"));
        return len >= minLen && len <= maxLen;
    }

    public List<String[]> getRouteCountries() throws Exception {
        if (this._routeFilters == null) {
            throw new Exception("Route countries have not been loaded.");
        }
        ArrayList<String[]> countriesList = new ArrayList<String[]>();
        for (Map.Entry<String, HashMap<String, Object>> kvp : this._routeFilters.entrySet()) {
            String countryCode = kvp.getKey();
            String countryName = kvp.getValue().get("countryName").toString();
            String dialCode = kvp.getValue().get("dialCode").toString();
            countriesList.add(new String[]{countryName, countryCode, dialCode});
        }
        return countriesList;
    }

    public HashMap<String, Object> getDefaultRouteInfo() {
        return this._defaultRoute;
    }

    public HashMap<String, HashMap<String, Object>> getRouteFilters() {
        return this._routeFilters;
    }

    public HashMap<String, Object> getMessageSenders() {
        return this._messageSenders;
    }

    public SMSType getDefaultTextMessageType() {
        return this._textMsgType;
    }

    public String[] getDefaultTimeZone() {
        if (this._timeZone != null) {
            return this._timeZone.split("/");
        }
        return null;
    }
}

