/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Utils;

import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Enums.SMSType;
import Zenoph.Notify.Report.MessageReport;
import Zenoph.Notify.Report.SMSReport;
import Zenoph.Notify.Report.VoiceReport;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageUtil {
    private Cipher cipher = null;
    private Key aesKey = null;
    private static List<HashMap<String, Object>> _messageTypes = null;
    private static HashMap<String, List<String[]>> _timeZones = null;
    public static final String PHONE_NUMBER_PATTERN = "\\+?[0-9]{8,13}";
    private static final String TZ_OFFSET_PATTERN = "^(\\+|-)(([0][0-9]:[0-5][0-9])|([1][0-2]:[0-5][0-9])|(13:00))$";
    public static final int CUSTOM_MSGID_MIN_LEN = 30;
    public static final int CUSTOM_MSGID_MAX_LEN = 40;

    private static void initCrypto() {
    }

    public static String encodeString(String str) {
        MessageUtil.initCrypto();
        return MessageUtil.toHexString(str.getBytes());
    }

    public static String decodeString(String str) {
        return MessageUtil.fromHexString(str);
    }

    private static String toHexString(byte[] ba) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            str.append(String.format("%x", ba[i]));
        }
        return str.toString();
    }

    private static String fromHexString(String hex) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            str.append((char)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        return str.toString();
    }

    public static boolean isNumericSender(String sender) {
        return MessageUtil.isRegexMatch("/^(\\+)?\\d+$/", sender);
    }

    public static boolean isRegexMatch(String pattern, String str) {
        return MessageUtil.isRegexMatch(pattern, str, false);
    }

    public static boolean isRegexMatch(String pattern, String str, boolean dotAll) {
        Pattern pat = dotAll ? Pattern.compile(pattern, 32) : Pattern.compile(pattern);
        return pat.matcher(str).find();
    }

    public static List<String> getRegexMatches(String pattern, String str) {
        return null;
    }

    public static boolean isValidTimeZoneUTCOffset(String str) {
        return MessageUtil.isRegexMatch(TZ_OFFSET_PATTERN, str);
    }

    public static MessageCategory messageCategoryToEnum(String category) throws Exception {
        switch (category) {
            case "sms": {
                return MessageCategory.SMS;
            }
            case "voice": {
                return MessageCategory.VOICE;
            }
            case "ussd": {
                return MessageCategory.USSD;
            }
        }
        throw new Exception(String.format("Unknown message category specifier [%s]", category));
    }

    public static SMSType messageTypeToEnum(String type) throws Exception {
        if (type == null || type.isEmpty()) {
            throw new Exception("Invalid reference to message type label.");
        }
        if (_messageTypes == null) {
            throw new Exception("Text message types have not been loaded.");
        }
        for (int i = 0; i < _messageTypes.size(); ++i) {
            HashMap<String, Object> typeInfo = _messageTypes.get(i);
            if (!typeInfo.get("label").toString().equalsIgnoreCase(type)) continue;
            return SMSType.fromInt(Integer.parseInt(typeInfo.get("id").toString()));
        }
        throw new Exception(String.format("Message type label '%s' was not found.", type));
    }

    public static HashMap<String, Object> getMessageTypeInfo(SMSType type) throws Exception {
        if (_messageTypes == null) {
            return null;
        }
        for (int i = 0; i < _messageTypes.size(); ++i) {
            HashMap<String, Object> typeInfo = _messageTypes.get(i);
            int typeId = Integer.parseInt(typeInfo.get("id").toString());
            if (type != SMSType.fromInt(typeId)) continue;
            return typeInfo;
        }
        throw new Exception("Text message type identifier was not found.");
    }

    public static String messageTypeToStr(SMSType type) throws Exception {
        if (_messageTypes == null) {
            throw new Exception("Invalid message type specifier.");
        }
        int typeId = type.getId();
        for (int i = 0; i < _messageTypes.size(); ++i) {
            HashMap<String, Object> typeInfo = _messageTypes.get(i);
            if (Integer.parseInt(typeInfo.get("id").toString()) != typeId) continue;
            return typeInfo.get("label").toString();
        }
        throw new Exception("Message type enumerator was not found.");
    }

    public static void extractGeneralSettings(Document xmlDoc) throws Exception {
        _messageTypes = MessageUtil.extractMessageTypes(xmlDoc);
        _timeZones = MessageUtil.extractTimeZones(xmlDoc);
    }

    private static List<HashMap<String, Object>> extractMessageTypes(Document xmlDoc) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node baseNode = (Node)xpath.compile("data/settings/general/messageTypes").evaluate(xmlDoc, XPathConstants.NODE);
        ArrayList<HashMap<String, Object>> msgTypes = new ArrayList<HashMap<String, Object>>();
        NodeList nodes = (NodeList)xpath.compile("type").evaluate(baseNode, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            HashMap<String, String> type = new HashMap<String, String>();
            Node node = (Node)xpath.compile("id").evaluate(nodes.item(i), XPathConstants.NODE);
            type.put("id", node.getTextContent());
            node = (Node)xpath.compile("label").evaluate(nodes.item(i), XPathConstants.NODE);
            type.put("label", node.getTextContent());
            node = (Node)xpath.compile("singleLen").evaluate(nodes.item(i), XPathConstants.NODE);
            type.put("singleLen", node.getTextContent());
            node = (Node)xpath.compile("concatLen").evaluate(nodes.item(i), XPathConstants.NODE);
            type.put("concatLen", node.getTextContent());
            node = (Node)xpath.compile("charLen").evaluate(nodes.item(i), XPathConstants.NODE);
            type.put("charLen", node.getTextContent());
            msgTypes.add(type);
        }
        return msgTypes;
    }

    private static HashMap<String, List<String[]>> extractTimeZones(Document xmlDoc) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        HashMap<String, List<String[]>> timeZones = new HashMap<String, List<String[]>>();
        NodeList nodes = (NodeList)xpath.compile("data/settings/general/timeZones/region").evaluate(xmlDoc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String regionName = ((Element)nodes.item(i)).getAttribute("name");
            NodeList citiesNodes = (NodeList)xpath.compile("city").evaluate(nodes.item(i), XPathConstants.NODESET);
            ArrayList<String[]> citiesList = new ArrayList<String[]>();
            for (int j = 0; j < citiesNodes.getLength(); ++j) {
                String[] hm = new String[]{citiesNodes.item(j).getTextContent(), ((Element)citiesNodes.item(j)).getAttribute("offset")};
                citiesList.add(hm);
            }
            timeZones.put(regionName, citiesList);
        }
        return timeZones;
    }

    public static List<HashMap<String, Object>> getMessageTypes() {
        return _messageTypes;
    }

    public static HashMap<String, List<String[]>> getTimeZones() {
        return _timeZones;
    }

    public static String getMessageCategoryLabel(MessageCategory category) throws Exception {
        switch (category) {
            case SMS: {
                return "sms";
            }
            case VOICE: {
                return "voice";
            }
            case USSD: {
                return "ussd";
            }
        }
        throw new Exception("Unknown message category identifier.");
    }

    public static MessageReport createReport(HashMap<String, Object> p) throws Exception {
        if (p.get("category") == MessageCategory.SMS) {
            return SMSReport.create(p);
        }
        if (p.get("category") == MessageCategory.VOICE) {
            return VoiceReport.create(p);
        }
        throw new Exception("Invalid or unsupported message category for report.");
    }
}

